<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

$page_heading       = ( $_GET['subpage'] == 'add-legend-item' ? __( 'Add New Legend Item', 'wp-simple-booking-calendar' ) : __( 'Edit Legend Item', 'wp-simple-booking-calendar' ) );
$page_wrap_class    = ( $_GET['subpage'] == 'add-legend-item' ? 'wpsbc-wrap-add-legend-item' : 'wpsbc-wrap-edit-legend-item' );
$submit_button_text = ( $_GET['subpage'] == 'add-legend-item' ? __( 'Add Legend Item', 'wp-simple-booking-calendar' ) : __( 'Save Legend Item', 'wp-simple-booking-calendar' ) );
$action				= ( $_GET['subpage'] == 'add-legend-item' ? 'add_legend_item' : 'edit_legend_item' );

$name  		= ( ! empty( $_POST['legend_item_name'] ) ? $_POST['legend_item_name'] : '' );
$type  		= ( ! empty( $_POST['legend_item_type'] ) ? $_POST['legend_item_type'] : '' );
$color 		= ( ! empty( $_POST['legend_item_color'] ) ? $_POST['legend_item_color'] : array() );
$color_text = ( ! empty( $_POST['legend_item_color_text'] ) ? $_POST['legend_item_color_text'] : '' );
$changeover_type = ( ! empty( $_POST['legend_item_changeover_type'] ) ? $_POST['legend_item_changeover_type'] : '' );

$settings = get_option( 'wpsbc_settings', array() );

// Set values for the edit page
if( $_GET['subpage'] == 'edit-legend-item' ) {

	$legend_item = wpsbc_get_legend_item( absint( $_GET['legend_item_id'] ) );

	$name  		= ( ! empty( $name ) ? $name : $legend_item->get('name') );
	$type  		= ( ! empty( $type ) ? $type : $legend_item->get('type') );
	$color 		= ( ! empty( $color ) ? $color : $legend_item->get('color') );
	$color_text = ( ! empty( $color_text ) ? $color_text : $legend_item->get('color_text') );
	$changeover_type = ( ! empty( $changeover_type ) ? $changeover_type : $legend_item->get('changeover_type') );

}

?>

<div class="wrap wpsbc-wrap <?php echo $page_wrap_class; ?>">

	<form action="" method="POST">

		<!-- Page Heading -->
		<h1 class="wp-heading-inline"><?php echo $page_heading; ?></h1>

		<!-- Page Heading Actions -->
		<div class="wpsbc-heading-actions">

			<!-- Submit -->
		<input type="submit" value="<?php echo $submit_button_text; ?>" class="button button-primary" />

		<!-- Back to Legend -->
		<a class="button button-secondary" href="<?php echo add_query_arg( array( 'subpage' => 'view-legend' ), remove_query_arg( array( 'legend_item_id', 'wpsbc_message' ) ) ); ?>"><?php echo __( 'Back to Legend', 'wp-simple-booking-calendar' ); ?></a>
			
		</div>
		
		<hr class="wp-header-end" />

		<!-- General Settings Panel -->
		<div class="metabox-holder">
			<div class="postbox">

				<h3 class="hndle"><?php echo __( 'General', 'wp-simple-booking-calendar' ); ?></h3>

				<div class="inside">
					
					<!-- Name -->
					<div class="wpsbc-admin-field-wrapper wpsbc-field-inline">
						<label for="wpsbc-legend-item-name"><?php echo __( 'Name', 'wp-simple-booking-calendar' ); ?></label>
						<div class="wpsbc-admin-field-inner">
							<input id="wpsbc-legend-item-name" name="legend_item_name" type="text" value="<?php echo esc_attr( $name ); ?>" class="wpsbc-medium" />
						</div>
					</div>

					<!-- Type -->
					<div class="wpsbc-admin-field-wrapper wpsbc-field-inline">
						<label for="wpsbc-legend-item-type"><?php echo __( 'Type', 'wp-simple-booking-calendar' ); ?></label>
						<div class="wpsbc-admin-field-inner">
							<select id="wpsbc-legend-item-type" name="legend_item_type" class="wpsbc-medium">
								<option value="single" <?php selected( $type, 'single' ); ?>><?php echo __( 'Single', 'wp-simple-booking-calendar' ); ?></option>
								<option value="split" <?php selected( $type, 'split' ); ?>><?php echo __( 'Split', 'wp-simple-booking-calendar' ); ?></option>
							</select>
						</div>
					</div>

					<!-- Color -->
					<div class="wpsbc-admin-field-wrapper wpsbc-field-inline">
						<label for="color-1"><?php echo __( 'Color', 'wp-simple-booking-calendar' ); ?></label>

						<div class="wpsbc-admin-field-inner">
							<input id="wpsbc-legend-item-color-1" name="legend_item_color[]" class="wpsbc-colorpicker" type="text" value="<?php echo esc_attr( ! empty( $color[0] ) ? $color[0] : '' ); ?>" class="wpsbc-medium" />
							<input id="wpsbc-legend-item-color-2" name="legend_item_color[]" class="wpsbc-colorpicker" type="text" value="<?php echo esc_attr( ! empty( $color[1] ) ? $color[1] : '' ); ?>" class="wpsbc-medium" />
						</div>
					</div>

					<!-- Changeover Type -->
					<div class="wpsbc-admin-field-wrapper wpsbc-field-inline wpsbc-admin-field-changeover-type">
						<label for="wpsbc-legend-item-changeover-type">
							<?php echo __( 'Changeover Type', 'wp-simple-booking-calendar' ); ?>
							<?php echo wpsbc_get_output_tooltip(__('Set the type of the changeover legend. This is used by the search widget to return correct results when searching through changeover legend items.', 'wp-simple-booking-calendar' )) ?>
						</label>
						<div class="wpsbc-admin-field-inner">
							<select id="wpsbc-legend-item-changeover-type" name="legend_item_changeover_type" class="wpsbc-medium">
								<option value="" <?php selected( $changeover_type, '' ); ?>>-</option>
								<option value="start" <?php selected( $changeover_type, 'start' ); ?>><?php echo __( 'Starting Changeover', 'wp-simple-booking-calendar' ); ?></option>
								<option value="end" <?php selected( $changeover_type, 'end' ); ?>><?php echo __( 'Ending Changeover', 'wp-simple-booking-calendar' ); ?></option>
							</select>
						</div>
					</div>

					<!-- Text Color -->
					<div class="wpsbc-admin-field-wrapper wpsbc-field-inline">
						<label for="color-text"><?php echo __( 'Text Color', 'wp-simple-booking-calendar' ); ?></label>

						<div class="wpsbc-admin-field-inner">
							<input id="wpsbc-legend-item-color-text" name="legend_item_color_text" class="wpsbc-colorpicker" type="text" value="<?php echo esc_attr( ! empty( $color_text ) ? $color_text : '' ); ?>" class="wpsbc-medium" />
						</div>
					</div>

				</div>
			</div>
		</div><!-- / Settings Panel -->

		<!-- Translations Panel -->
		<?php
			$active_languages = ( ! empty( $settings['active_languages'] ) ? $settings['active_languages'] : array() );
			$languages 		  = wpsbc_get_languages();
		?>
		<?php if( ! empty( $active_languages ) ): ?>
		<div class="metabox-holder">
			<div class="postbox">

				<h3 class="hndle"><?php echo __( 'Translations', 'wp-simple-booking-calendar' ); ?></h3>

				<div class="inside">
					
					<?php foreach( $active_languages as $code ): ?>

					<?php 

						if( $_GET['subpage'] == 'edit-legend-item' )
							$value = wpsbc_get_legend_item_meta( $legend_item->get('id'), 'translation_' . $code, true );
						else
							$value = '';

					?>

					<div class="wpsbc-admin-field-wrapper wpsbc-field-inline">

						<label for="wpsbc-legend-item-translation-<?php echo esc_attr( $code ); ?>">
							<img src="<?php echo WPSBC_PLUGIN_DIR_URL . 'assets/img/flags/' . esc_attr( $code ) . '.png'; ?>" />
							<?php echo ( ! empty( $languages[$code] ) ? $languages[$code] : '' ); ?>
						</label>

						<div class="wpsbc-admin-field-inner">
							<input id="wpsbc-legend-item-translation-<?php echo esc_attr( $code ); ?>" name="legend_item_translation_<?php echo esc_attr( $code ); ?>" type="text" value="<?php echo esc_attr( $value ); ?>" class="wpsbc-medium" />
						</div>

					</div>

					<?php endforeach; ?>

				</div>
			</div>
		</div><!-- / Settings Panel -->
		<?php endif; ?>

		<!-- Extra -->
		<?php do_action( 'wpsbc_admin_view_add_edit_legend_item' ); ?>

		<!-- Nonce -->
		<?php wp_nonce_field( 'wpsbc_' . $action, 'wpsbc_token', false ); ?>
		<input type="hidden" name="wpsbc_action" value="<?php echo $action; ?>" />

		<!-- Submit -->
		<input type="submit" value="<?php echo $submit_button_text; ?>" class="button button-primary" />

		<!-- Back to Legend -->
		<a class="button button-secondary" href="<?php echo add_query_arg( array( 'subpage' => 'view-legend' ), remove_query_arg( array( 'legend_item_id', 'wpsbc_message' ) ) ); ?>"><?php echo __( 'Back to Legend', 'wp-simple-booking-calendar' ); ?></a>

	</form>

</div>