<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

$calendar_id = ( ! empty( $_GET['calendar_id'] ) ? absint( $_GET['calendar_id'] ) : 0 );
$calendar    = wpsbc_get_calendar( $calendar_id );

$legend_items 		 = wpsbc_get_legend_items( array( 'calendar_id' => $calendar_id ) );

?>

<div class="wrap wpsbc-wrap wpsbc-wrap-export-csv">

	<!-- Page Heading -->
	<h1 class="wp-heading-inline"><?php echo __( 'CSV Export', 'wp-simple-booking-calendar' ); ?><span class="wpsbc-heading-tag"><?php printf( __( 'Calendar ID: %d', 'wp-simple-booking-calendar' ), $calendar_id ); ?></span></h1>
	
	<!-- Page Heading Actions -->
	<div class="wpsbc-heading-actions">
		<a href="<?php echo add_query_arg( array( 'subpage' => 'edit-calendar' ) ); ?>" class="button-secondary"><?php echo __( 'Back to Calendar', 'wp-simple-booking-calendar' ); ?></a>
	</div>

	<hr class="wp-header-end" />

	<!-- Dashboard Widgets Wrapper -->
	<div>

		<div id="dashboard-widgets" class="metabox-holder ">

			<!-- Row -->
			<div class="wpsbc-row">

				<!-- Col 1-1 -->
				<div class="wpsbc-col-1-1">

					<!-- Postbox Export -->
					<div class="postbox" style="margin-bottom: 0;">

						<form method="POST" action="">

							<h2 class="hndle"><span class="dashicons dashicons-media-spreadsheet"></span>&nbsp;&nbsp;<?php echo __( 'Export', 'wp-simple-booking-calendar' ); ?></h2>

							<!-- Form Fields -->
							<div class="inside">

								<!-- Export Legend Items -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label" for="csv-export-legend-items"><?php echo __( 'Legend Items to Export', 'wp-simple-booking-calendar' ); ?></label>

									<div class="wpsbc-settings-field-inner wpsbc-chosen-wrapper">

										<select multiple class="wpsbc-chosen" name="csv-export-legend-items[]" id="csv-export-legend-items">
											<?php 
												foreach( $legend_items as $legend_item ) {
													echo '<option ' . ( isset($_POST['csv-export-legend-items']) && in_array($legend_item->get('id'), $_POST['csv-export-legend-items']) ? 'selected' : '' ) . ' value="' . esc_attr( $legend_item->get('id') ) . '">' . $legend_item->get('name') . '</option>';
												}
											?>
										</select>

									</div>

								</div>

								<!-- Export Format -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label" for="csv-export-format"><?php echo __( 'Export Format', 'wp-simple-booking-calendar' ); ?></label>

									<div class="wpsbc-settings-field-inner">

										<select name="csv-export-format" id="csv-export-format">
											<option <?php echo (isset($_POST['csv-export-format']) && !empty($_POST['csv-export-format'])) ? selected($_POST['csv-export-format'], 'groupped_date', false) : ''; ?> value="groupped_date"><?php echo __('date, legend, description', 'wp-simple-booking-calendar') ?></option>
											<option <?php echo (isset($_POST['csv-export-format']) && !empty($_POST['csv-export-format'])) ? selected($_POST['csv-export-format'], 'individual_dates', false) : ''; ?> value="individual_dates"><?php echo __('year, month, day, legend, description', 'wp-simple-booking-calendar') ?></option>
										</select>

									</div>

								</div>

								<!-- Period -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label" for="csv-export-period"><?php echo __( 'Export Period', 'wp-simple-booking-calendar' ); ?></label>

									<div class="wpsbc-settings-field-inner">

										<input value="<?php echo (isset($_POST['wpsbc-export-csv-start-date']) && !empty($_POST['wpsbc-export-csv-start-date'])) ? esc_attr($_POST['wpsbc-export-csv-start-date']) : ''; ?>" type="text" class="wpsbc-export-csv-date" name="wpsbc-export-csv-start-date" id="wpsbc-export-csv-start-date" placeholder="from" readonly>

										<input value="<?php echo (isset($_POST['wpsbc-export-csv-end-date']) && !empty($_POST['wpsbc-export-csv-end-date'])) ? esc_attr($_POST['wpsbc-export-csv-end-date']) : ''; ?>" type="text" class="wpsbc-export-csv-date" name="wpsbc-export-csv-end-date" id="wpsbc-export-csv-end-date" placeholder="to" readonly>
										
									</div>

									<small><em><?php echo __('Leave empty if you wish to export the entire calendar', 'wp-simple-booking-calendar') ?></em></small>

								</div>

							</div>

							<!-- Card Bottom -->
							<div class="wpsbc-plugin-card-bottom plugin-card-bottom">
								
								<input type="submit" class="button-primary" value="<?php echo __( 'Export CSV', 'wp-simple-booking-calendar' ); ?>" />
							</div>

							<!-- Calendar ID -->
							<input type="hidden" name="calendar_id" value="<?php echo $calendar_id; ?>" />

							<!-- Nonce -->
							<?php wp_nonce_field( 'wpsbc_csv_export', 'wpsbc_token', false ); ?>
							<input type="hidden" name="wpsbc_action" value="csv_export" />

						</form>

					</div>

				</div>

			</div><!-- / Row -->


		</div>

	</div>

</div>