<?php
$settings = get_option( 'wpsbc_settings', array() );
$active_languages = (!empty($settings['active_languages']) ? $settings['active_languages'] : array());
$languages = wpsbc_get_languages();

$default_strings = wpsbc_search_widget_default_strings();
$strings = array(
    'widget_title' => array(
        'label' => __('Search Widget Title', 'wp-simple-booking-calendar')
    ),
    'start_date_label' => array(
        'label' => __('Start Date Label', 'wp-simple-booking-calendar'),
    ),
    'start_date_placeholder' => array(
        'label' => __('Start Date Placeholder', 'wp-simple-booking-calendar'),
    ),
    'end_date_label' => array(
        'label' => __('End Date Label', 'wp-simple-booking-calendar'),
    ),
    'end_date_placeholder' => array(
        'label' => __('End Date Placeholder', 'wp-simple-booking-calendar'),
    ),
    'search_button_label' => array(
        'label' => __('Search Button Label', 'wp-simple-booking-calendar')
    ),
    'no_start_date' => array(
        'label' => __('No Start Date Error', 'wp-simple-booking-calendar'),
    ),
    'no_end_date' => array(
        'label' => __('No End Date Error', 'wp-simple-booking-calendar'),
    ),
    'invalid_start_date' => array(
        'label' => __('Invalid Start Date Error', 'wp-simple-booking-calendar'),
    ),
    'invalid_end_date' => array(
        'label' => __('Invalid End Date Error', 'wp-simple-booking-calendar'),
    ),
    'results_title' => array(
        'label' => __('Results Title', 'wp-simple-booking-calendar'),
    ),
    'no_results' => array(
        'label' => __('No Results Warning', 'wp-simple-booking-calendar'),
    ),
    'view_button_label' => array(
        'label' => __('Details Button Label', 'wp-simple-booking-calendar'),
    ),
    'label_previous' => array(
        'label' => __('Pagination - Previous', 'wp-simple-booking-calendar'),
    ),
    'label_next' => array(
        'label' => __('Pagination - Next', 'wp-simple-booking-calendar'),
    )
);?>


<!-- Styling -->
<h2><?php echo __( 'Styling', 'wp-simple-booking-calendar' ); ?></h2>
<div class="wpsbc-settings-fields-form-styling">

	<!-- Button Style -->
	<div class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline">
		<label class="wpsbc-settings-field-label"><?php echo __( 'Button Style', 'wp-simple-booking-calendar' ); ?></label>
		<div class="wpsbc-settings-field-inner wpsbc-settings-field-inner-inline">
			<input name="wpsbc_settings[search_addon][button_background_color]" type="text" class="wpsbc-colorpicker" value="<?php echo ( ! empty( $settings['search_addon']['button_background_color'] ) ? esc_attr( $settings['search_addon']['button_background_color'] ) : '' ); ?>" />
			<small><?php echo __('Background Color', 'wp-simple-booking-calendar') ?></small>
		</div>
		<div class="wpsbc-settings-field-inner wpsbc-settings-field-inner-inline">
			<input name="wpsbc_settings[search_addon][button_text_color]" type="text" class="wpsbc-colorpicker" value="<?php echo ( ! empty( $settings['search_addon']['button_text_color'] ) ? esc_attr( $settings['search_addon']['button_text_color'] ) : '' ); ?>" />
			
			<small><?php echo __('Text Color','wp-simple-booking-calendar') ?></small>
		</div>
	</div>

	<!-- Button Hover Style  -->
	<div class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline">
		<label class="wpsbc-settings-field-label"><?php echo __( 'Button Hover Style', 'wp-simple-booking-calendar' ); ?></label>
		<div class="wpsbc-settings-field-inner wpsbc-settings-field-inner-inline">
			<input name="wpsbc_settings[search_addon][button_background_hover_color]" type="text" class="wpsbc-colorpicker" value="<?php echo ( ! empty( $settings['search_addon']['button_background_hover_color'] ) ? esc_attr( $settings['search_addon']['button_background_hover_color'] ) : '' ); ?>" />
			<small><?php echo __('Background Color', 'wp-simple-booking-calendar') ?></small>
		</div>
		<div class="wpsbc-settings-field-inner wpsbc-settings-field-inner-inline">
			<input name="wpsbc_settings[search_addon][button_text_hover_color]" type="text" class="wpsbc-colorpicker" value="<?php echo ( ! empty( $settings['search_addon']['button_text_hover_color'] ) ? esc_attr( $settings['search_addon']['button_text_hover_color'] ) : '' ); ?>" />
			<small><?php echo __('Text Color','wp-simple-booking-calendar') ?></small>
		</div>
	</div>

</div>

<!-- Strings -->
<h2><?php echo __( 'Strings', 'wp-simple-booking-calendar' ); ?></h2>
<?php foreach ($strings as $key => $string): ?>
<!-- Required Field -->
<div class="wpsbc-settings-field-translation-wrapper">
    <div class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline wpsbc-settings-field-large">
        <label class="wpsbc-settings-field-label" for="wpsbc_settings_search_addon_<?php echo $key;?>">
            <?php echo $string['label'] ?>
            <?php if(isset($string['tooltip'])): ?>
                <?php echo wpsbc_get_output_tooltip($string['tooltip']);?>
            <?php endif ?>
        </label>
        <div class="wpsbc-settings-field-inner">
            <input name="wpsbc_settings[search_addon][<?php echo $key;?>]" type="text" id="wpsbc_settings_search_addon_<?php echo $key;?>" value="<?php echo (!empty($settings['search_addon'][$key])) ? esc_attr($settings['search_addon'][$key]) : $default_strings[$key]; ?>" class="regular-text" >
            <?php if (wpsbc_translations_active()): ?><a href="#" class="wpsbc-settings-field-show-translations"><?php echo __('Translations', 'wp-simple-booking-calendar'); ?> <span class="dashicons dashicons-arrow-down"></span></a><?php endif?>
        </div>
    </div>
    <?php if (wpsbc_translations_active()): ?>
    <!-- Required Field Translations -->
    <div class="wpsbc-settings-field-translations">
        <?php foreach ($active_languages as $language): ?>
            <div class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline wpsbc-settings-field-large">
                <label class="wpsbc-settings-field-label" for="wpsbc_settings_search_addon_<?php echo $key;?>_translation_<?php echo $language; ?>"><img src="<?php echo WPSBC_PLUGIN_DIR_URL; ?>/assets/img/flags/<?php echo $language; ?>.png" /> <?php echo $languages[$language]; ?></label>
                <div class="wpsbc-settings-field-inner">
                    <input name="wpsbc_settings[search_addon][<?php echo $key;?>_translation_<?php echo $language; ?>]" type="text" id="wpsbc_settings_search_addon_<?php echo $key;?>_translation_<?php echo $language; ?>" value="<?php echo (!empty($settings['search_addon'][$key.'_translation_' . $language])) ? esc_attr($settings['search_addon'][$key.'_translation_' . $language]) : ''; ?>" class="regular-text" >
                </div>
            </div>
        <?php endforeach;?>
    </div>
    <?php endif; ?>
</div>
<?php endforeach;?>

<!-- Submit button -->
<input type="submit" class="button-primary" value="<?php echo __( 'Save Settings', 'wp-simple-booking-calendar' ); ?>" />