(function ($) {

    wp.customize('header_background_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header').css('background-color', newval);
        });
    });

    wp.customize('header_text_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-calendar-header-navigation').css('color', newval);
        });
    });

    wp.customize('header_arrow_background_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-next, .wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-prev').css('background-color', newval);
        });
    });

    wp.customize('header_arrow_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-prev .wpsbc-arrow').css('border-color', 'transparent ' + newval + ' transparent transparent');
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-next .wpsbc-arrow').css('border-color', 'transparent transparent transparent' + newval);
        });
    });

    wp.customize('calendar_background_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar, .wpsbc-legend, .wpsbc-yearly-calendar-row .wpsbc-yearly-calendar-row-header').css('background-color', newval);
        });
    });
    wp.customize('calendar_border_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar, .wpsbc-legend').css('border-color', newval);

        });
    });
    wp.customize('calendar_text_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar, .wpsbc-legend').css('color', newval);
        });
    });


    wp.customize('header_dropdown_background_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-select-container select').css('background-color', newval);
        });
    });
    wp.customize('header_dropdown_border_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-select-container select').css('border-color', newval);
        });
    });
    wp.customize('header_dropdown_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-select-container select').css('color', newval);
        });
    });

    wp.customize('dates_pad_cells', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar table tr td .wpsbc-date.wpsbc-gap').css('background-color', newval);
        });
    });

    wp.customize('dates_weeknumbers', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar table td .wpsbc-week-number').css('background-color', newval);
        });
    });

    wp.customize('dates_border_radius', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-container .wpsbc-calendars .wpsbc-calendar table tr td .wpsbc-date, .wpsbc-container .wpsbc-calendars .wpsbc-calendar table td .wpsbc-week-number, .wpsbc-yearly-calendar-row-header-inner').css('border-radius', newval + 'px');
        });
    });

    wp.customize('form_text_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-main-wrapper .wpsbc-form-container, .wpsbc-main-wrapper .wpsbc-form-confirmation-message').css('color', newval);
        });
    });

    wp.customize('form_field_background_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type=email], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type=number], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type=text], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field textarea, .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field select, .wpsbc-form-field-signature .wpsbc-signature-pad canvas').each(function () {
                $(this)[0].style.setProperty('background-color', newval, 'important');
            })
        });
    });

    wp.customize('form_field_border_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type=email], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type=number], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type=text], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field textarea, .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field select, .wpsbc-form-field-signature .wpsbc-signature-pad canvas, .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-number-stylised-ui button').each(function () {
                $(this)[0].style.setProperty('border-color', newval, 'important');
            })

        });
    });

    wp.customize('form_payment_description', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-payment-method-description').each(function () {
                $(this)[0].style.setProperty('background-color', newval, 'important');
            })

        });
    });

    wp.customize('form_field_text_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type=email], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type=number], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type=text], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field textarea, .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field select, .wpsbc-payment-method-description').each(function () {
                $(this)[0].style.setProperty('color', newval, 'important');
            });
            $(".wpsbc-form-field-signature .wpsbc-signature-pad a.wpsbc-clear-signature svg path").css('fill', newval)

        });
    });

    wp.customize('form_field_description_text_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field-description small').each(function () {
                $(this)[0].style.setProperty('color', newval, 'important');
            })
        });
    });

    wp.customize('form_field_border_radius', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type=email], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field:not(.wpsbc-number-stylised-ui) input[type=number], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type=text], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field textarea, .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field select, .wpsbc-form-field-signature .wpsbc-signature-pad canvas').each(function () {
                $(this)[0].style.setProperty('border-radius', newval + 'px', 'important');
            });
            $('.wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field button.wpsbc-coupon-code-button').each(function () {
                $(this)[0].style.setProperty('border-top-right-radius', newval + 'px', 'important');
                $(this)[0].style.setProperty('border-bottom-right-radius', newval + 'px', 'important');
            });

            $('.iti--separate-dial-code .iti__selected-flag').each(function () {
                $(this)[0].style.setProperty('border-top-left-radius', newval + 'px', 'important');
                $(this)[0].style.setProperty('border-bottom-left-radius', newval + 'px', 'important');
            });

            $('.wpsbc-main-wrapper .wpsbc-form-container .wpsbc-number-stylised-ui button.wpsbc-number-increment-plus').each(function () {
                $(this)[0].style.setProperty('border-top-right-radius', newval + 'px', 'important');
                $(this)[0].style.setProperty('border-bottom-right-radius', newval + 'px', 'important');
            });

            $('.wpsbc-main-wrapper .wpsbc-form-container .wpsbc-number-stylised-ui button.wpsbc-number-increment-minus').each(function () {
                $(this)[0].style.setProperty('border-top-left-radius', newval + 'px', 'important');
                $(this)[0].style.setProperty('border-bottom-left-radius', newval + 'px', 'important');
            });

        });
    });


    wp.customize('form_button_border_radius', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field button[type="submit"], .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field input[type="submit"], .wpsbc-payment-confirmation-stripe-form #wpsbc-stripe-card-button, .wpsbc-payment-confirmation-square-form #wpsbc-square-card-button, #wpsbc-authorize-net-button-container #wpsbc-authorize-net-submit').each(function () {
                $(this)[0].style.setProperty('border-radius', newval + 'px', 'important');
            });

        });
    });

    wp.customize('form_error_message_color', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-main-wrapper .wpsbc-form-general-error, .wpsbc-main-wrapper .wpsbc-form-container .wpsbc-form-field-error').each(function () {
                $(this)[0].style.setProperty('color', newval, 'important');
            });
        });
    });

    wp.customize('form_max_width', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-main-wrapper .wpsbc-payment-confirmation, .wpsbc-main-wrapper .wpsbc-form-container').each(function () {
                $(this)[0].style.setProperty('max-width', newval + 'px', 'important');
            });
        });
    });

    wp.customize('form_table_heading_background', function (value) {
        value.bind(function (newval) {
            $('.wpsbc-main-wrapper table.wpsbc-pricing-table thead th, .wpsbc-main-wrapper table.wpsbc-pricing-table tr.wpsbc-line-item-subtotal td, .wpsbc-main-wrapper table.wpsbc-pricing-table tr.wpsbc-line-item-total td').each(function () {
                $(this)[0].style.setProperty('background-color', newval, 'important');
            });
            $('.wpsbc-main-wrapper table.wpsbc-pricing-table td, .wpsbc-main-wrapper table.wpsbc-pricing-table th, .wpsbc-main-wrapper table.wpsbc-pricing-table td:first-child, .wpsbc-main-wrapper table.wpsbc-pricing-table th:first-child').each(function () {
                $(this)[0].style.setProperty('border-color', newval, 'important');
            });
        });
    });


})(jQuery);