<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

$calendar_id = absint( ! empty( $_GET['calendar_id'] ) ? $_GET['calendar_id'] : 0 );
$calendar    = wpsbc_get_calendar( $calendar_id );

if( is_null( $calendar ) )
	return;

$current_year  = ( ! empty( $_GET['year'] )  ? absint( $_GET['year'] )  : current_time('Y') );
$current_month = ( ! empty( $_GET['month'] ) ? absint( $_GET['month'] ) : current_time('n') );

$settings = get_option( 'wpsbc_settings', array() );

$removable_query_args = wp_removable_query_args();

$languages = wpsbc_get_languages();
$active_languages = ( ! empty( $settings['active_languages'] ) ? $settings['active_languages'] : array() );

?>

<div class="wrap wpsbc-wrap wpsbc-wrap-edit-calendar">

	<form method="POST" action="" autocomplete="off">

		<!-- Page Heading -->
		<h1 class="wp-heading-inline"><?php echo __( 'Edit Calendar', 'wp-simple-booking-calendar' ); ?><span class="wpsbc-heading-tag"><?php printf( __( 'Calendar ID: %d', 'wp-simple-booking-calendar' ), $calendar_id ); ?></span></h1>

		<!-- Page Heading Actions -->
		<div class="wpsbc-heading-actions">

			<!-- Back Button -->
			<a href="<?php echo add_query_arg( array( 'page' => 'wpsbc-calendars'), admin_url( 'admin.php' ) ); ?>" class="button-secondary"><?php echo __('Back to all calendars', 'wp-simple-booking-calendar') ?></a>

			<!-- Save button -->
			<input type="submit" class="wpsbc-save-calendar button-primary" value="<?php echo __( 'Save Calendar', 'wp-simple-booking-calendar' ); ?>" />
			
		</div>

		<hr class="wp-header-end" />

		<div id="poststuff">

			<!-- Calendar Title -->
			<div id="titlediv">
				<div id="titlewrap">
					<input type="text" name="calendar_name" size="30" value="<?php echo esc_attr( $calendar->get('name') ) ?>" id="title">

					<?php if(isset($settings['active_languages']) && count($settings['active_languages']) > 0): ?>

						<a href="#" class="titlewrap-toggle"><?php echo __('Translate calendar title','wp-simple-booking-calendar') ?> <svg aria-hidden="true" focusable="false" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" ><path fill="currentColor" d="M31.3 192h257.3c17.8 0 26.7 21.5 14.1 34.1L174.1 354.8c-7.8 7.8-20.5 7.8-28.3 0L17.2 226.1C4.6 213.5 13.5 192 31.3 192z" class=""></path></svg></a>
						<div class="titlewrap-translations">
							<?php foreach($settings['active_languages'] as $language): ?>
								<div class="titlewrap-translation">
									<div class="titlewrap-translation-flag"><img src="<?php echo WPSBC_PLUGIN_DIR_URL; ?>assets/img/flags/<?php echo $language;?>.png" /></div>
									<input type="text" name="calendar_name_translation_<?php echo $language;?>" size="30" value="<?php echo esc_attr( wpsbc_get_calendar_meta($calendar->get('id'), 'calendar_name_translation_' . $language, true) ) ?>" >
								</div>
							<?php endforeach; ?>
						</div>

					<?php endif ?>
				</div>
			</div>

			<div id="post-body" class="metabox-holder columns-2">

				<!-- Main Post Body Content -->
				<div id="post-body-content">
					
					<!-- Availability -->
					<div class="postbox">

						<h3 class="hndle"><?php echo __( 'Edit Dates', 'wp-simple-booking-calendar' ); ?></h3>

						<div class="inside">
							
							<div id="wpsbc-calendar-events">
								<?php
									$calendar_args = array(
										'current_year'  => $current_year,
										'current_month' => $current_month
									);

									$calendar_editor = new WPSBC_Calendar_Editor_Outputter( $calendar, $calendar_args );
									$calendar_editor->display();
								?>
							</div>

						</div>
					</div>

					<!-- Link Calendar -->
					<div class="postbox">

						<h3 class="hndle"><?php echo __( 'Link Calendar', 'wp-simple-booking-calendar' ); ?><?php echo wpsbc_get_output_tooltip( __( "You can attach a post/page from your WordPress website or an external link to this calendar. If the calendar has a link attached, everywhere the calendar's title is displayed, the link will automatically be added to the title.", 'wp-simple-booking-calendar' ) ); ?></h3>

						<div class="inside">

							<div class="wpsbc-row wpsbc-last">

								<!-- Link Type -->
								<div class="wpsbc-col-1-4">

									<div class="wpsbc-settings-field-wrapper wpsbc-last">

										<label class="wpsbc-settings-field-label"><?php echo __('Link Type', 'wp-simple-booking-calendar'); ?></label>

										<div class="wpsbc-settings-field-inner">

											<?php $calendar_link_type = wpsbc_get_calendar_meta($calendar->get('id'), 'calendar_link_type', true);?>

											<select name="calendar_link_type">
												<option value="internal" <?php selected($calendar_link_type, 'internal', true);?>><?php echo __('Internal', 'wp-simple-booking-calendar'); ?></option>
												<option value="external" <?php selected($calendar_link_type, 'external', true);?>><?php echo __('External', 'wp-simple-booking-calendar'); ?></option>
											</select>
										</div>

									</div>

								</div>

								<!-- Actual Link -->
								<div class="wpsbc-col-3-4">

									<!-- Internal Link -->
									<div id="wpsbc-settings-field-wrapper-calendar-link-internal" class="wpsbc-settings-field-wrapper wpsbc-settings-field-wrapper-link-calendar wpsbc-last">

										<label class="wpsbc-settings-field-label"><?php echo __('Select Internal Link', 'wp-simple-booking-calendar'); ?></label>
										
										<?php $post_types_dropdown = wpsbc_get_post_types_as_dropdown();?>

										<div class="wpsbc-settings-field-translation-wrapper">

											<div class="wpsbc-settings-field-inner">

												<?php $calendar_link_internal = wpsbc_get_calendar_meta($calendar->get('id'), 'calendar_link_internal', true); ?>

												<select name="calendar_link_internal">
													<option value=""><?php echo __('Select...', 'wp-simple-booking-calendar'); ?></option>
													<?php foreach($post_types_dropdown as $post_type => $posts): ?>
														<optgroup label="<?php echo $post_type;?>">
															<?php foreach($posts as $post_id => $post_title): ?>
																<option value="<?php echo $post_id;?>" <?php selected($calendar_link_internal, $post_id);?>><?php echo $post_title;?></option>
															<?php endforeach; ?>
														</optgroup>
													<?php endforeach; ?>
												</select>
												<?php if(wpsbc_translations_active()): ?><a href="#" class="wpsbc-settings-field-show-translations"><?php echo __( 'Translations', 'wp-simple-booking-calendar' ); ?> <span class="dashicons dashicons-arrow-down"></span></a><?php endif ?>

											</div>

											<?php if(wpsbc_translations_active()): ?>
											<!-- Subject Translations -->
											<div class="wpsbc-settings-field-translations">
												<?php foreach($active_languages as $language): ?>

													<?php $calendar_link_internal_translation = wpsbc_get_calendar_meta($calendar->get('id'), 'calendar_link_internal_translation_'. $language, true); ?>

													<!-- Submit Button -->
													<div class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline wpsbc-settings-field-large">

														<label class="wpsbc-settings-field-label" for="calendar_link_internal_translation_<?php echo $language;?>"><img src="<?php echo WPSBC_PLUGIN_DIR_URL ;?>/assets/img/flags/<?php echo $language;?>.png" /> <?php echo $languages[$language];?></label>

														<div class="wpsbc-settings-field-inner">
															<select name="calendar_link_internal_translation_<?php echo $language;?>" id="calendar_link_internal_translation_<?php echo $language;?>">
																<option value=""><?php echo __('Select...', 'wp-simple-booking-calendar'); ?></option>
																<?php foreach($post_types_dropdown as $post_type => $posts): ?>
																	<optgroup label="<?php echo $post_type;?>">
																		<?php foreach($posts as $post_id => $post_title): ?>
																			<option value="<?php echo $post_id;?>" <?php selected($calendar_link_internal_translation, $post_id);?>><?php echo $post_title;?></option>
																		<?php endforeach; ?>
																	</optgroup>
																<?php endforeach; ?>
															</select>
														</div>
														
													</div>
												<?php endforeach; ?>
											</div>
											<?php endif ?>

										</div>

									</div>

									<!-- External Link -->
									<div id="wpsbc-settings-field-wrapper-calendar-link-external" class="wpsbc-settings-field-wrapper wpsbc-settings-field-wrapper-link-calendar wpsbc-last">

										<label class="wpsbc-settings-field-label"><?php echo __('Add External Link', 'wp-simple-booking-calendar'); ?></label>

										<div class="wpsbc-settings-field-translation-wrapper">

											<div class="wpsbc-settings-field-inner">

												<?php $calendar_link_external = wpsbc_get_calendar_meta($calendar->get('id'), 'calendar_link_external', true);?>

												<input type="text" name="calendar_link_external" value="<?php echo esc_attr($calendar_link_external); ?>" />
												<?php if(wpsbc_translations_active()): ?><a href="#" class="wpsbc-settings-field-show-translations"><?php echo __( 'Translations', 'wp-simple-booking-calendar' ); ?> <span class="dashicons dashicons-arrow-down"></span></a><?php endif ?>
											</div>

											<?php if(wpsbc_translations_active()): ?>
											<!-- Subject Translations -->
											<div class="wpsbc-settings-field-translations">
												<?php foreach($active_languages as $language): ?>

													<!-- Submit Button -->
													<div class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline wpsbc-settings-field-large">

														<label class="wpsbc-settings-field-label" for="calendar_link_external_translation_<?php echo $language;?>"><img src="<?php echo WPSBC_PLUGIN_DIR_URL ;?>/assets/img/flags/<?php echo $language;?>.png" /> <?php echo $languages[$language];?></label>

														<div class="wpsbc-settings-field-inner">
															<input name="calendar_link_external_translation_<?php echo $language;?>" type="text" id="calendar_link_external_translation_<?php echo $language;?>" value="<?php echo esc_attr(wpsbc_get_calendar_meta($calendar->get('id'), 'calendar_link_external_translation_' . $language, true));?>" class="regular-text" >
														</div>
														
													</div>
												<?php endforeach; ?>
											</div>
											<?php endif ?>
										</div>

									</div>

								</div>

							</div>

						</div>
						
					</div>

					<!-- Notes -->
					<div class="postbox">

						<h3 class="hndle"><?php echo __( 'Notes', 'wp-simple-booking-calendar' ); ?></h3>

						<div class="inside">
							
							<div class="wpsbc-calendar-notes">
								
								<?php wpsbc_output_notes_html($calendar_id);?>
								
							</div>

							<div class="wpsbc-calendar-new-note">
								<h4><?php echo __( 'Add new note', 'wp-simple-booking-calendar' ); ?></h4>
								<textarea name="wpsbc-calendar-note-content" id="wpsbc-calendar-note-content" placeholder="<?php echo __( 'Start writing your note here...', 'wp-simple-booking-calendar' ); ?>" cols="30" rows="10"></textarea>								
								<button class="button-secondary" id="wpsbc-calendar-add-note"><?php echo __( 'Add Note', 'wp-simple-booking-calendar' ); ?></button>
							</div>

						</div>
					</div>

					<?php

						/**
						 * Action hook to add extra form fields to the main calendar edit area
						 *
						 * @param WPSBC_Calendar $calendar
						 *
						 */
						do_action( 'wpsbc_view_edit_calendar_main', $calendar );

					?>

				</div><!-- / Main Post Body Content -->

				<!-- Sidebar Content -->
				<div id="postbox-container-1" class="postbox-container">
		 			
		 			<!-- Calendar -->
		 			<div class="postbox">

						<h3 class="hndle"><?php echo __( 'Calendar', 'wp-simple-booking-calendar' ); ?></h3>

						<div class="inside">
							
							<?php
								$calendar_args = array(
									'current_year'  => $current_year,
									'current_month' => $current_month,
									'start_weekday' => ( ! empty( $settings['backend_start_day'] ) ? (int)$settings['backend_start_day'] : 1 ),
									'show_title'  	=> 0,
									'show_legend' 	=> 0,
									'is_admin' => true
								);

								$calendar_args = apply_filters('wpsbc_calendar_editor_sidebar_calendar_args', $calendar_args);

								$calendar_outputter = new WPSBC_Calendar_Outputter( $calendar, $calendar_args );
								$calendar_outputter->display();
							?>

						</div>
					</div><!-- / Calendar -->

					<!-- Calendar Legend -->
		 			<div class="postbox">

						<h3 class="hndle"><?php echo __( 'Legend', 'wp-simple-booking-calendar' ); ?></h3>

						<div class="inside">
							
							<?php
								$legend_items = wpsbc_get_legend_items( array( 'calendar_id' => $calendar_id ) );

								foreach( $legend_items as $legend_item ) {

									echo '<div class="wpsbc-legend-item">';
										echo wpsbc_get_legend_item_icon( $legend_item->get('id'), $legend_item->get('type'), $legend_item->get('color') );
										echo '<span class="wpsbc-legend-item-name">' . $legend_item->get('name') . '</span>';
									echo '</div>';

								}
							?>

						</div>

						<div class="wpsbc-plugin-card-bottom plugin-card-bottom">
							<a class="button-secondary" href="<?php echo add_query_arg( array( 'page' => 'wpsbc-calendars', 'calendar_id' => $calendar->get('id'),'subpage' => 'view-legend' ), admin_url( 'admin.php' ) ); ?>"><?php echo __( 'Edit Legend Items', 'wp-simple-booking-calendar' ); ?></a>
						</div>

					</div><!-- / Calendar Legend -->

					<!-- Availability Bulk Edit -->
		 			<div id="wpsbc-bulk-edit-availability-wrapper" class="postbox">

						<h3 class="hndle"><?php echo __( 'Bulk Edit Availability', 'wp-simple-booking-calendar' ); ?></h3>

						<div class="inside">
							
							<!-- Start Date -->
							<p>
								<label for="wpsbc-bulk-edit-availability-start-date"><?php echo __( 'Start Date', 'wp-simple-booking-calendar' ); ?></label>
								<input id="wpsbc-bulk-edit-availability-start-date" type="text" class="wpsbc-datepicker" placeholder="YYYY-MM-DD" readonly />
							</p>

							<!-- End Date -->
							<p>
								<label for="wpsbc-bulk-edit-availability-end-date"><?php echo __( 'End Date', 'wp-simple-booking-calendar' ); ?></label>
								<input id="wpsbc-bulk-edit-availability-end-date" type="text" class="wpsbc-datepicker" placeholder="YYYY-MM-DD" readonly />
							</p>

							<!-- Week Days -->
							<p>
								<label for="wpsbc-bulk-edit-availability-week-days" >
									<?php echo __('Week Days', 'wp-simple-booking-calendar'); ?>
									<?php echo wpsbc_get_output_tooltip(__('Only select specific week days from the date range chosen above. Leave empty to select all days.', 'wp-simple-booking-calendar')); ?>
								</label>
								<span class="wpsbc-bulk-edit-availability-week-days-wrapper">

									<?php $start_weekday = (!empty($settings['backend_start_day']) ? (int) $settings['backend_start_day'] : 1); ?>

									<?php for( $i = $start_weekday; $i < ( $start_weekday + 7 ); $i++ ):?>

										<?php $week_day_letter = wpsbc_get_days_first_letters(wpsbc_get_locale())[($i + 6) % 7];?>

										<?php $week_day = $i % 7; ?>
										
										<label for="wpsbc-bulk-edit-availability-week-day-<?php echo $week_day;?>" class="wpsbc-bulk-edit-availability-week-days">
											<span><?php echo $week_day_letter;?></span>
											<input type="checkbox" id="wpsbc-bulk-edit-availability-week-day-<?php echo $week_day;?>" name="wpsbc-bulk-edit-availability-week-day" class="wpsbc-bulk-edit-availability-week-day" value="<?php echo $week_day;?>" />
										</label>

									<?php endfor; ?>

								</span>
							</p>

							<!-- Legend Item -->
							<p>
								<label for="wpsbc-bulk-edit-availability-legend-item"><?php echo __( 'Legend Item', 'wp-simple-booking-calendar' ); ?></label>
								<select id="wpsbc-bulk-edit-availability-legend-item">
								<?php
									foreach( $legend_items as $legend_item ) {

										echo '<option value="' . esc_attr( $legend_item->get('id') ) . '">' . $legend_item->get('name') . '</option>';

									}
								?>
								</select>
							</p>

							<!-- Description -->
							<p>
								<label for="wpsbc-bulk-edit-availability-description"><?php echo __( 'Description', 'wp-simple-booking-calendar' ); ?></label>
								<input id="wpsbc-bulk-edit-availability-description" type="text" />
							</p>

							<!-- Tooltip -->
							<p>
								<label for="wpsbc-bulk-edit-availability-tooltip"><?php echo __( 'Tooltip', 'wp-simple-booking-calendar' ); ?></label>
								<input id="wpsbc-bulk-edit-availability-tooltip" type="text" />
							</p>

						</div>

						<div class="wpsbc-plugin-card-bottom plugin-card-bottom">
							<a id="wpsbc-bulk-edit-availability" class="button-secondary wpsbc-float-right" href="#"><?php echo __( 'Bulk Edit', 'wp-simple-booking-calendar' ); ?></a>
							<a id="wpsbc-bulk-edit-availability-undo" class="wpsbc-inactive" href="#"><?php echo __( 'Undo', 'wp-simple-booking-calendar' ); ?></a>
							<?php echo wpsbc_get_output_tooltip( __( 'Clicking the "Undo" link will undo the last bulk edit action you have made, just in case you have made a mistake.', 'wp-simple-booking-calendar' ) ); ?>
						</div>

					</div><!-- / Availability Bulk Edit -->


					<!-- iCal Export -->
					<div class="postbox">

						<h3 class="hndle"><?php echo __( 'iCal Import/Export', 'wp-simple-booking-calendar' ); ?></h3>

						<div class="inside">

							<p><?php echo __( 'To configure the iCal import & export settings and have access to the iCal export link please click the button below.', 'wp-simple-booking-calendar' ); ?></p>

							<a href="<?php echo add_query_arg( array( 'page' => 'wpsbc-calendars', 'calendar_id' => $calendar->get('id'),'subpage' => 'ical-import-export' ), admin_url( 'admin.php' ) ); ?>" class="button-secondary"><span class="dashicons dashicons-upload"></span> <?php echo __( 'iCal Import/Export', 'wp-simple-booking-calendar' ); ?></a>

						</div>

					</div><!-- / iCal Export -->


					<!-- CSV Export -->
					<div class="postbox">

						<h3 class="hndle"><?php echo __( 'CSV Export', 'wp-simple-booking-calendar' ); ?></h3>

						<div class="inside">

							<p><?php echo __( 'To configure the CSV export settings please click the button below. ', 'wp-simple-booking-calendar' ); ?></p>

							<a href="<?php echo add_query_arg( array( 'page' => 'wpsbc-calendars', 'calendar_id' => $calendar->get('id'),'subpage' => 'csv-export' ), admin_url( 'admin.php' ) ); ?>" class="button-secondary"><span class="dashicons dashicons-media-spreadsheet"></span> <?php echo __( 'CSV Export', 'wp-simple-booking-calendar' ); ?></a>

						</div>

					</div><!-- / CSV Export -->


					<?php

						/**
						 * Action hook to add extra form fields to the main calendar edit area
						 *
						 * @param WPSBC_Calendar $calendar
						 *
						 */
						do_action( 'wpsbc_view_edit_calendar_sidebar', $calendar );

					?>

				</div><!-- / Sidebar Content -->

			</div><!-- / #post-body -->

		</div><!-- / #poststuff -->

		<!-- Hidden fields -->
		<input type="hidden" name="calendar_id" value="<?php echo $calendar_id; ?>" />

		<!-- Nonce -->
		<?php wp_nonce_field( 'wpsbc_save_calendar', 'wpsbc_token', false ); ?>

		<!-- Save button -->
		<input type="submit" class="wpsbc-save-calendar button-primary" value="<?php echo __( 'Save Calendar', 'wp-simple-booking-calendar' ); ?>" />

		<!-- Save Button Spinner -->
		<div class="wpsbc-save-calendar-spinner spinner"><!-- --></div>

	</form>

</div>