<?php

// Exit if accessed directly
if (! defined('ABSPATH')) exit;

?>

<div id="wpsbc-modal-add-calendar-shortcode" class="wpsbc-modal">

	<!-- Modal Header -->
	<div class="wpsbc-modal-header">

		<h2>
			<span class="dashicons dashicons-calendar-alt"><!-- --></span>
			<?php echo __('Add Calendar', 'wp-simple-booking-calendar'); ?>
		</h2>

		<span class="wpsbc-modal-close dashicons dashicons-no-alt"><!-- --></span>

	</div>

	<!-- Modal Body -->
	<div class="wpsbc-modal-body">

		<!-- Modal Nav Tab  -->
		<ul class="wpsbc-modal-nav-tab-wrapper">
			<li class="wpsbc-nav-tab wpsbc-modal-nav-tab wpsbc-active" data-tab="calendar-single"><a href="#"><?php echo __('Insert Calendar', 'wp-simple-booking-calendar'); ?></a></li>
			<li class="wpsbc-nav-tab wpsbc-modal-nav-tab" data-tab="calendar-overview"><a href="#"><?php echo __('Insert Overview Calendar', 'wp-simple-booking-calendar'); ?></a></li>
			<li class="wpsbc-nav-tab wpsbc-modal-nav-tab" data-tab="calendar-search-widget"><a href="#"><?php echo __('Insert Search Widget', 'wp-simple-booking-calendar'); ?></a></li>
		</ul>

		<!-- Modal Body Inner -->
		<div class="wpsbc-modal-inner">

			<!-- Modal Tab: Calendar Single -->
			<div class="wpsbc-tab wpsbc-modal-tab wpsbc-active" data-tab="calendar-single">

				<h3><?php echo __('Insert a Calendar', 'wp-simple-booking-calendar'); ?></h3>
				<p><?php echo __('Select which calendar you wish to insert and use the options to customize it to your needs.', 'wp-simple-booking-calendar'); ?></p>

				<h4><?php echo __('Basic Options', 'wp-simple-booking-calendar'); ?></h4>
				<hr />

				<!-- Row -->
				<div class="wpsbc-row">

					<!-- Column: Calendar -->
					<div class="wpsbc-col-1-4">

						<?php $calendars = wpsbc_get_calendars(); ?>

						<label for="modal-add-calendar-shortcode-calendar"><?php echo __('Calendar', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-calendar" class="wpsbc-shortcode-generator-field-calendar" data-attribute="id">
							<?php
							foreach ($calendars as $calendar)
								echo '<option value="' . $calendar->get('id') . '">' . $calendar->get('name') . '</option>';
							?>
						</select>

					</div>

					<!-- Column: Calendar Title -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-calendar-title"><?php echo __('Display Calendar Title', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-calendar-title" class="wpsbc-shortcode-generator-field-calendar" data-attribute="title">
							<option value="yes"><?php echo __('Yes', 'wp-simple-booking-calendar'); ?></option>
							<option value="no"><?php echo __('No', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Legend -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-legend"><?php echo __('Display Legend', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-legend" class="wpsbc-shortcode-generator-field-calendar" data-attribute="legend">
							<option value="yes"><?php echo __('Yes', 'wp-simple-booking-calendar'); ?></option>
							<option value="no"><?php echo __('No', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Legend Position -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-legend-position"><?php echo __('Legend Position', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-legend-position" class="wpsbc-shortcode-generator-field-calendar" data-attribute="legend_position">
							<option value="side"><?php echo __('Side', 'wp-simple-booking-calendar'); ?></option>
							<option value="top"><?php echo __('Top', 'wp-simple-booking-calendar'); ?></option>
							<option value="bottom"><?php echo __('Bottom', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

				</div><!-- / Row -->

				<!-- Row -->
				<div class="wpsbc-row">

					<!-- Column: Months to Display -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-months-to-display"><?php echo __('Months to Display', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-months-to-display" class="wpsbc-shortcode-generator-field-calendar" data-attribute="display">
							<?php
							for ($i = 1; $i <= 12; $i++)
								echo '<option value="' . $i . '">' . $i . '</option>';
							?>
						</select>

					</div>

					<!-- Column: Start Year -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-start-year"><?php echo __('Start Year', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-start-year" class="wpsbc-shortcode-generator-field-calendar" data-attribute="year">
							<option value="0"><?php echo __('Current Year', 'wp-simple-booking-calendar'); ?></option>
							<?php
							for ($i = date('Y'); $i <= date('Y') + 10; $i++)
								echo '<option value="' . $i . '">' . $i . '</option>';
							?>
						</select>

					</div>

					<!-- Column: Start Month -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-start-month"><?php echo __('Start Month', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-start-month" class="wpsbc-shortcode-generator-field-calendar" data-attribute="month">
							<option value="0"><?php echo __('Current Month', 'wp-simple-booking-calendar'); ?></option>
							<option value="1"><?php echo __('January', 'wp-simple-booking-calendar'); ?></option>
							<option value="2"><?php echo __('February', 'wp-simple-booking-calendar'); ?></option>
							<option value="3"><?php echo __('March', 'wp-simple-booking-calendar'); ?></option>
							<option value="4"><?php echo __('April', 'wp-simple-booking-calendar'); ?></option>
							<option value="5"><?php echo __('May', 'wp-simple-booking-calendar'); ?></option>
							<option value="6"><?php echo __('June', 'wp-simple-booking-calendar'); ?></option>
							<option value="7"><?php echo __('July', 'wp-simple-booking-calendar'); ?></option>
							<option value="8"><?php echo __('August', 'wp-simple-booking-calendar'); ?></option>
							<option value="9"><?php echo __('September', 'wp-simple-booking-calendar'); ?></option>
							<option value="10"><?php echo __('October', 'wp-simple-booking-calendar'); ?></option>
							<option value="11"><?php echo __('November', 'wp-simple-booking-calendar'); ?></option>
							<option value="12"><?php echo __('December', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

				</div><!-- / Row -->

				<h4><?php echo __('Advanced Options', 'wp-simple-booking-calendar'); ?></h4>
				<hr />

				<!-- Row -->
				<div class="wpsbc-row">

					<!-- Column: Week Start Day -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-week-start-day"><?php echo __('Week Start Day', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-week-start-day" class="wpsbc-shortcode-generator-field-calendar" data-attribute="start">
							<option value="1"><?php echo __('Monday', 'wp-simple-booking-calendar'); ?></option>
							<option value="2"><?php echo __('Tuesday', 'wp-simple-booking-calendar'); ?></option>
							<option value="3"><?php echo __('Wednesday', 'wp-simple-booking-calendar'); ?></option>
							<option value="4"><?php echo __('Thursday', 'wp-simple-booking-calendar'); ?></option>
							<option value="5"><?php echo __('Friday', 'wp-simple-booking-calendar'); ?></option>
							<option value="6"><?php echo __('Saturday', 'wp-simple-booking-calendar'); ?></option>
							<option value="7"><?php echo __('Sunday', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Dropdown -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-dropdown"><?php echo __('Display Selection Dropdown', 'wp-simple-booking-calendar'); ?><?php echo wpsbc_get_output_tooltip(__("If set to yes, the calendar will display a month and year drop-down select field as a navigation alternative to the arrows.", 'wp-simple-booking-calendar')); ?></label>

						<select id="modal-add-calendar-shortcode-dropdown" class="wpsbc-shortcode-generator-field-calendar" data-attribute="dropdown">
							<option value="yes"><?php echo __('Yes', 'wp-simple-booking-calendar'); ?></option>
							<option value="no"><?php echo __('No', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Jump Switch -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-jump-switch"><?php echo __('Use Jump Switch', 'wp-simple-booking-calendar'); ?><?php echo wpsbc_get_output_tooltip(__("If set to yes and if the calendar displays multiple months, when the user uses the arrows to navigate the calendar, the calendar will switch the number of months selected, rather than just one month.", 'wp-simple-booking-calendar')); ?></label>

						<select id="modal-add-calendar-shortcode-jump-switch" class="wpsbc-shortcode-generator-field-calendar" data-attribute="jump">
							<option value="yes"><?php echo __('Yes', 'wp-simple-booking-calendar'); ?></option>
							<option value="no" selected><?php echo __('No', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Show history -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-history"><?php echo __('Show History', 'wp-simple-booking-calendar'); ?><?php echo wpsbc_get_output_tooltip(__("This option lets you decide how past dates are being displayed for the user in the front-end.", 'wp-simple-booking-calendar')); ?></label>

						<select id="modal-add-calendar-shortcode-history" class="wpsbc-shortcode-generator-field-calendar" data-attribute="history">
							<option value="1"><?php echo __('Display booking history', 'wp-simple-booking-calendar'); ?></option>
							<option value="2"><?php echo __('Replace booking history with the default legend item', 'wp-simple-booking-calendar'); ?></option>
							<option value="3"><?php echo __('Use the Booking History Color from the Settings', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

				</div><!-- / Row -->

				<!-- Row -->
				<div class="wpsbc-row">

					<!-- Column: Display Tooltips -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-tooltip"><?php echo __('Display Tooltips', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-tooltip" class="wpsbc-shortcode-generator-field-calendar" data-attribute="tooltip">
							<option value="1"><?php echo __('No', 'wp-simple-booking-calendar'); ?></option>
							<option value="2"><?php echo __('Yes', 'wp-simple-booking-calendar'); ?></option>
							<option value="3"><?php echo __('Yes, with red indicator', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Highlight Today -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-highlight-today"><?php echo __('Highlight Today', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-highlight-today" class="wpsbc-shortcode-generator-field-calendar" data-attribute="highlighttoday">
							<option value="yes"><?php echo __('Yes', 'wp-simple-booking-calendar'); ?></option>
							<option value="no" selected><?php echo __('No', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Show week numbers -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-week-numbers"><?php echo __('Show Week Numbers', 'wp-simple-booking-calendar'); ?><?php echo wpsbc_get_output_tooltip(__("If set to yes, it will display at the beginning of each week the week's number counted from the beginning of the year.", 'wp-simple-booking-calendar')); ?></label>

						<select id="modal-add-calendar-shortcode-week-numbers" class="wpsbc-shortcode-generator-field-calendar" data-attribute="weeknumbers">
							<option value="yes"><?php echo __('Yes', 'wp-simple-booking-calendar'); ?></option>
							<option value="no" selected><?php echo __('No', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Language -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-language"><?php echo __('Language', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-language" class="wpsbc-shortcode-generator-field-calendar" data-attribute="language">

							<option value="auto"><?php echo __('Auto (let WP choose)', 'wp-simple-booking-calendar'); ?></option>

							<?php

							$settings 		  = get_option('wpsbc_settings', array());
							$languages 		  = wpsbc_get_languages();
							$active_languages = (! empty($settings['active_languages']) ? $settings['active_languages'] : array());

							foreach ($active_languages as $code) {

								echo '<option value="' . esc_attr($code) . '">' . (! empty($languages[$code]) ? $languages[$code] : '') . '</option>';
							}

							?>

						</select>

					</div>

				</div><!-- / Row -->

				<hr />

				<!-- Shortcode insert -->
				<a href="#" id="wpsbc-insert-shortcode-single-calendar" class="button button-primary"><?php echo __('Insert Calendar', 'wp-simple-booking-calendar'); ?></a>
				<a href="#" class="button button-secondary wpsbc-modal-close"><?php echo __('Cancel', 'wp-simple-booking-calendar'); ?></a>

			</div>

			<!-- Modal Tab: Calendar Overview -->
			<div class="wpsbc-tab wpsbc-modal-tab" data-tab="calendar-overview">

				<h3><?php echo __('Insert a Multiple Overview Calendar', 'wp-simple-booking-calendar'); ?></h3>
				<p><?php echo __('Create a calendar overview that displays all selected calendars and their availability', 'wp-simple-booking-calendar'); ?></p>


				<h4><?php echo __('Calendar Selection', 'wp-simple-booking-calendar'); ?></h4>
				<hr />

				<!-- Row -->
				<div class="wpsbc-row">

					<!-- Column: Calendars -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-overview-shortcode-calendars"><?php echo __('Display Calendars', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-overview-shortcode-calendars">
							<option value="1"><?php echo __('All Calendars', 'wp-simple-booking-calendar'); ?></option>
							<option value="2"><?php echo __('Selected Calendars', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Selected Calendars -->
					<div class="wpsbc-col-3-4 wpsbc-element-disabled wpsbc-chosen-wrapper">

						<label for="modal-add-calendar-overview-shortcode-selected-calendars"><?php echo __('Select Calendars', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-overview-shortcode-selected-calendars" multiple class="wpsbc-chosen">
							<?php
							foreach ($calendars as $calendar)
								echo '<option value="' . $calendar->get('id') . '">' . $calendar->get('name') . '</option>';
							?>
						</select>

					</div>

				</div><!-- / Row -->

				<h4><?php echo __('Basic Options', 'wp-simple-booking-calendar'); ?></h4>
				<hr />

				<!-- Row -->
				<div class="wpsbc-row">

					<!-- Column: Legend -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-overview-shortcode-legend"><?php echo __('Display Legend', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-overview-shortcode-legend" class="wpsbc-shortcode-generator-field-calendar-overview" data-attribute="legend">
							<option value="yes"><?php echo __('Yes', 'wp-simple-booking-calendar'); ?></option>
							<option value="no"><?php echo __('No', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Legend Position -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-overview-shortcode-legend-position"><?php echo __('Legend Position', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-overview-shortcode-legend-position" class="wpsbc-shortcode-generator-field-calendar-overview" data-attribute="legend_position">
							<option value="top"><?php echo __('Top', 'wp-simple-booking-calendar'); ?></option>
							<option value="bottom"><?php echo __('Bottom', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Start Year -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-overview-shortcode-start-year"><?php echo __('Start Year', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-overview-shortcode-start-year" class="wpsbc-shortcode-generator-field-calendar-overview" data-attribute="start_year">
							<option value="0"><?php echo __('Current Year', 'wp-simple-booking-calendar'); ?></option>
							<?php
							for ($i = date('Y'); $i <= date('Y') + 10; $i++)
								echo '<option value="' . $i . '">' . $i . '</option>';
							?>
						</select>

					</div>

					<!-- Column: Start Month -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-overview-shortcode-start-month"><?php echo __('Start Month', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-overview-shortcode-start-month" class="wpsbc-shortcode-generator-field-calendar-overview" data-attribute="start_month">
							<option value="0"><?php echo __('Current Month', 'wp-simple-booking-calendar'); ?></option>
							<option value="1"><?php echo __('January', 'wp-simple-booking-calendar'); ?></option>
							<option value="2"><?php echo __('February', 'wp-simple-booking-calendar'); ?></option>
							<option value="3"><?php echo __('March', 'wp-simple-booking-calendar'); ?></option>
							<option value="4"><?php echo __('April', 'wp-simple-booking-calendar'); ?></option>
							<option value="5"><?php echo __('May', 'wp-simple-booking-calendar'); ?></option>
							<option value="6"><?php echo __('June', 'wp-simple-booking-calendar'); ?></option>
							<option value="7"><?php echo __('July', 'wp-simple-booking-calendar'); ?></option>
							<option value="8"><?php echo __('August', 'wp-simple-booking-calendar'); ?></option>
							<option value="9"><?php echo __('September', 'wp-simple-booking-calendar'); ?></option>
							<option value="10"><?php echo __('October', 'wp-simple-booking-calendar'); ?></option>
							<option value="11"><?php echo __('November', 'wp-simple-booking-calendar'); ?></option>
							<option value="12"><?php echo __('December', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

				</div><!-- / Row -->

				<h4><?php echo __('Advanced Options', 'wp-simple-booking-calendar'); ?></h4>
				<hr />

				<!-- Row -->
				<div class="wpsbc-row">

					<!-- Column: Show history -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-overview-shortcode-history"><?php echo __('Show History', 'wp-simple-booking-calendar'); ?><?php echo wpsbc_get_output_tooltip(__("This option lets you decide how past dates are being displayed for the user in the front-end.", 'wp-simple-booking-calendar')); ?></label>

						<select id="modal-add-calendar-overview-shortcode-history" class="wpsbc-shortcode-generator-field-calendar-overview" data-attribute="history">
							<option value="1"><?php echo __('Display booking history', 'wp-simple-booking-calendar'); ?></option>
							<option value="2"><?php echo __('Replace booking history with the default legend item', 'wp-simple-booking-calendar'); ?></option>
							<option value="3"><?php echo __('Use the Booking History Color from the Settings', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Display Tooltips -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-overview-shortcode-tooltip"><?php echo __('Display Tooltips', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-overview-shortcode-tooltip" class="wpsbc-shortcode-generator-field-calendar-overview" data-attribute="tooltip">
							<option value="1"><?php echo __('No', 'wp-simple-booking-calendar'); ?></option>
							<option value="2"><?php echo __('Yes', 'wp-simple-booking-calendar'); ?></option>
							<option value="3"><?php echo __('Yes, with red indicator', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Show week numbers -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-overview-shortcode-week-numbers"><?php echo __('Show Day Abbreviations', 'wp-simple-booking-calendar'); ?><?php echo wpsbc_get_output_tooltip(__("If set to yes, it will display a secondary calendar header for the dates (besides the day numbers), containing the first letter of the day's name. For example, Monday will display M.", 'wp-simple-booking-calendar')); ?></label>

						<select id="modal-add-calendar-overview-shortcode-week-numbers" class="wpsbc-shortcode-generator-field-calendar-overview" data-attribute="weeknumbers">
							<option value="yes"><?php echo __('Yes', 'wp-simple-booking-calendar'); ?></option>
							<option value="no" selected><?php echo __('No', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Language -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-language"><?php echo __('Language', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-calendar-shortcode-language" class="wpsbc-shortcode-generator-field-calendar-overview" data-attribute="language">

							<option value="auto"><?php echo __('Auto (let WP choose)', 'wp-simple-booking-calendar'); ?></option>

							<?php

							$settings 		  = get_option('wpsbc_settings', array());
							$languages 		  = wpsbc_get_languages();
							$active_languages = (! empty($settings['active_languages']) ? $settings['active_languages'] : array());

							foreach ($active_languages as $code) {

								echo '<option value="' . esc_attr($code) . '">' . (! empty($languages[$code]) ? $languages[$code] : '') . '</option>';
							}

							?>

						</select>

					</div>

				</div>

				<hr />

				<!-- Shortcode insert -->
				<a href="#" id="wpsbc-insert-shortcode-overview-calendar" class="button button-primary"><?php echo __('Insert Calendar Overview', 'wp-simple-booking-calendar'); ?></a>
				<a href="#" class="button button-secondary wpsbc-modal-close"><?php echo __('Cancel', 'wp-simple-booking-calendar'); ?></a>

			</div>

			<!-- Modal Tab: Search Widget -->
			<div class="wpsbc-tab wpsbc-modal-tab" data-tab="calendar-search-widget">

				<h3><?php echo __('Insert a Calendar Search Widget', 'wp-simple-booking-calendar'); ?></h3>
				<p><?php echo __('Create a search widget that allows the visitor to search for available dates in your calendars', 'wp-simple-booking-calendar'); ?></p>


				<h4><?php echo __('Search Widget', 'wp-simple-booking-calendar'); ?></h4>
				<hr />

				<!-- Row -->
				<div class="wpsbc-row">

					<!-- Column: Calendars -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-search-widget-shortcode-calendars"><?php echo __('Calendars', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-search-widget-shortcode-calendars">
							<option value="1"><?php echo __('All Calendars', 'wp-simple-booking-calendar'); ?></option>
							<option value="2"><?php echo __('Selected Calendars', 'wp-simple-booking-calendar'); ?></option>
						</select>

					</div>

					<!-- Column: Selected Calendars -->
					<div class="wpsbc-col-3-4 wpsbc-element-disabled wpsbc-chosen-wrapper">

						<label for="modal-add-search-widget-shortcode-selected-calendars"><?php echo __('Select Calendars', 'wp-simple-booking-calendar'); ?></label>

						<select id="modal-add-search-widget-shortcode-selected-calendars" multiple class="wpsbc-chosen">
							<?php $calendars = wpsbc_get_calendars(array('status' => 'active')); ?>
							<?php
							foreach ($calendars as $calendar) {
								echo '<option value="' . $calendar->get('id') . '">' . $calendar->get('name') . '</option>';
							}

							?>
						</select>

					</div>

				</div><!-- / Row -->

				<h4><?php echo __('Basic Options', 'wp-simple-booking-calendar'); ?></h4>
				<hr />

				<!-- Row -->
				<div class="wpsbc-row">

					<!-- Column: Language -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-search-widget-shortcode-language"><?php echo __('Language', 'wp-simple-booking-calendar-search'); ?></label>
						<select id="modal-add-search-widget-shortcode-language" class="wpsbc-shortcode-generator-field-search-widget" data-attribute="language">
							<option value="auto"><?php echo __('Auto (let WP choose)', 'wp-simple-booking-calendar-search'); ?></option>

							<?php

							$settings = get_option('wpsbc_settings', array());
							$languages = wpsbc_get_languages();
							$active_languages = (!empty($settings['active_languages']) ? $settings['active_languages'] : array());

							foreach ($active_languages as $code) {

								echo '<option value="' . esc_attr($code) . '">' . (!empty($languages[$code]) ? $languages[$code] : '') . '</option>';
							}

							?>
						</select>
					</div>

					<!-- Column: Week Start Day -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-calendar-shortcode-week-start-day"><?php echo __('Week Start Day', 'wp-simple-booking-calendar-search'); ?></label>

						<select id="modal-add-calendar-shortcode-week-start-day" class="wpsbc-shortcode-generator-field-search-widget" data-attribute="start_day">
							<option value="1"><?php echo __('Monday', 'wp-simple-booking-calendar-search'); ?></option>
							<option value="2"><?php echo __('Tuesday', 'wp-simple-booking-calendar-search'); ?></option>
							<option value="3"><?php echo __('Wednesday', 'wp-simple-booking-calendar-search'); ?></option>
							<option value="4"><?php echo __('Thursday', 'wp-simple-booking-calendar-search'); ?></option>
							<option value="5"><?php echo __('Friday', 'wp-simple-booking-calendar-search'); ?></option>
							<option value="6"><?php echo __('Saturday', 'wp-simple-booking-calendar-search'); ?></option>
							<option value="7"><?php echo __('Sunday', 'wp-simple-booking-calendar-search'); ?></option>
						</select>

					</div>

					<!-- Column: Widget Title -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-search-widget-shortcode-title"><?php echo __('Widget Title', 'wp-simple-booking-calendar-search'); ?></label>
						<select id="modal-add-search-widget-shortcode-title" class="wpsbc-shortcode-generator-field-search-widget" data-attribute="title">
							<option value="yes"><?php echo __('Yes', 'wp-simple-booking-calendar-search'); ?></option>
							<option value="no"><?php echo __('No', 'wp-simple-booking-calendar-search'); ?></option>
						</select>
					</div>

					<!-- Column: Selection Type -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-search-widget-shortcode-type"><?php echo __('Selection Type', 'wp-simple-booking-calendar-search'); ?></label>
						<select id="modal-add-search-widget-shortcode-type" class="wpsbc-shortcode-generator-field-search-widget" data-attribute="selection_type">
							<option value="multiple"><?php echo __('Date Range', 'wp-simple-booking-calendar-search'); ?></option>
							<option value="single"><?php echo __('Single Day', 'wp-simple-booking-calendar-search'); ?></option>
						</select>
					</div>

				</div><!-- / Row -->

				<div class="wpsbc-row">



					<!-- Column: Minimum Stay -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-search-widget-shortcode-minimum_stay"><?php echo __('Minimum Stay', 'wp-simple-booking-calendar-search'); ?></label>
						<input type="number" id="modal-add-search-widget-shortcode-minimum_stay" class="wpsbc-shortcode-generator-field-search-widget" data-attribute="minimum_stay" value="0" />
					</div>

					<!-- Column: Featured Image -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-search-widget-shortcode-featured-image"><?php echo __('Show Featured Image', 'wp-simple-booking-calendar-search'); ?></label>
						<select id="modal-add-search-widget-shortcode-featured-image" class="wpsbc-shortcode-generator-field-search-widget" data-attribute="featured_image">
							<option value="yes"><?php echo __('Yes', 'wp-simple-booking-calendar-search'); ?></option>
							<option value="no"><?php echo __('No', 'wp-simple-booking-calendar-search'); ?></option>
						</select>
					</div>

					<!-- Column: Starting Price -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-search-widget-shortcode-show-results-on-load"><?php echo __('Show Results on Load', 'wp-simple-booking-calendar-search'); ?></label>
						<select id="modal-add-search-widget-shortcode-show-results-on-load" class="wpsbc-shortcode-generator-field-search-widget" data-attribute="show_results_on_load">
							<option value="yes"><?php echo __('Yes', 'wp-simple-booking-calendar-search'); ?></option>
							<option value="no"><?php echo __('No', 'wp-simple-booking-calendar-search'); ?></option>
						</select>
					</div>

					<!-- Column: Results Layout -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-search-widget-shortcode-results-layout"><?php echo __('Results Layout', 'wp-simple-booking-calendar-search'); ?></label>
						<select id="modal-add-search-widget-shortcode-results-layout" class="wpsbc-shortcode-generator-field-search-widget" data-attribute="results_layout">
							<option value="list"><?php echo __('List', 'wp-simple-booking-calendar-search'); ?></option>
							<option value="grid"><?php echo __('Grid', 'wp-simple-booking-calendar-search'); ?></option>
						</select>
					</div>


				</div><!-- / Row -->

				<div class="wpsbc-row">

					<!-- Column: Results per Page -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-search-widget-shortcode-results-per-page"><?php echo __('Results per Page', 'wp-simple-booking-calendar-search'); ?></label>
						<input type="number" id="modal-add-search-widget-shortcode-results-per-page" class="wpsbc-shortcode-generator-field-search-widget" data-attribute="results_per_page" value="10" />
					</div>

					<!-- Column: Featured Image -->
					<div class="wpsbc-col-1-4">

						<label for="modal-add-search-widget-shortcode-redirect"><?php echo __('Redirect', 'wp-simple-booking-calendar-search'); ?></label>
						<input type="text" id="modal-add-search-widget-shortcode-redirect" class="widefat wpsbc-shortcode-generator-field-search-widget" data-attribute="redirect" />
					</div>

				</div>

				<h4><?php echo __('Strings', 'wp-simple-booking-calendar'); ?></h4>
				<hr />

				<!-- Row -->
				<div class="wpsbc-row">
					<p><?php echo sprintf(__('You can configure strings like labels and error messages from the <a target="_blank" href="%s">settings page</a>.', 'wp-simple-booking-calendar'), esc_url(add_query_arg(array('page' => 'wpsbc-settings', 'tab' => 'search-widget'), admin_url('admin.php')))); ?></p>

				</div>

				<hr />

				<!-- Shortcode insert -->
				<a href="#" id="wpsbc-insert-shortcode-search-widget" class="button button-primary"><?php echo __('Insert Search Widget', 'wp-simple-booking-calendar'); ?></a>
				<a href="#" class="button button-secondary wpsbc-modal-close"><?php echo __('Cancel', 'wp-simple-booking-calendar'); ?></a>

			</div>

		</div>

	</div>

</div>

<div id="wpsbc-modal-add-calendar-shortcode-overlay" class="wpsbc-modal-overlay"><!-- --></div>