<?php

class WPSBC_Customize
{

    public static function register($wp_customize)
    {

        $wp_customize->add_panel('wpsbc_options', array(
            'priority' => 200,
            'capability' => 'edit_theme_options',
            'title' => 'WP Simple Booking Calendar',
            'description' => __('Customize the look of the WP Simple Booking Calendar calendar.', 'wp-simple-booking-calendar'),
        ));

        $wp_customize->add_section(
            'wpsbc_calendar_options',
            array(
                'title' => 'Calendar',
                'priority' => 10,
                'panel' => 'wpsbc_options',
                'capability' => 'edit_theme_options',
            )
        );

        $wp_customize->add_section(
            'wpsbc_presets_options',
            array(
                'title' => 'Load Presets',
                'priority' => 30,
                'panel' => 'wpsbc_options',
                'capability' => 'edit_theme_options',
            )
        );

        // Date Padding Cells
        $wp_customize->add_setting(
            'preset_themes',
            array(
                'default' => '0',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            'wpsbc_preset_themes',
            array(
                'type' => 'select',
                'label' => __('Presets', 'wp-simple-booking-calendar'),
                'settings' => 'preset_themes',
                'choices' => array(
                    '' => '',
                    time() . '-default' => __('Default Theme', 'wp-simple-booking-calendar'),
                    time() . '-dark' => __('Dark Theme', 'wp-simple-booking-calendar'),
                ),
                'section' => 'wpsbc_presets_options',
            )
        ));

        $wp_customize->get_setting('preset_themes')->transport = 'postMessage';

        /**
         * Header
         */

        // Header Background Color
        $wp_customize->add_setting(
            'header_background_color',
            array(
                'default' => '#f5f5f5',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_header_background_color',
            array(
                'label' => __('Header - Background Color', 'wp-simple-booking-calendar'),
                'settings' => 'header_background_color',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('header_background_color')->transport = 'postMessage';

        // Header Text Color
        $wp_customize->add_setting(
            'header_text_color',
            array(
                'default' => '#000000',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_header_text_color',
            array(
                'label' => __('Header - Text Color', 'wp-simple-booking-calendar'),
                'settings' => 'header_text_color',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('header_text_color')->transport = 'postMessage';

        // Header Arrow Background Color
        $wp_customize->add_setting(
            'header_arrow_background_color',
            array(
                'default' => '#bdc3c7',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_header_arrow_background_color',
            array(
                'label' => __('Header - Arrow Background Color', 'wp-simple-booking-calendar'),
                'settings' => 'header_arrow_background_color',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('header_arrow_background_color')->transport = 'postMessage';

        // Header Arrow Color
        $wp_customize->add_setting(
            'header_arrow_color',
            array(
                'default' => '#fff',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_header_arrow_color',
            array(
                'label' => __('Header - Arrow Color', 'wp-simple-booking-calendar'),
                'settings' => 'header_arrow_color',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('header_arrow_color')->transport = 'postMessage';

        // Dropdown Background Color
        $wp_customize->add_setting(
            'header_dropdown_background_color',
            array(
                'default' => '#fff',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_header_dropdown_background_color',
            array(
                'label' => __('Header - Dropdown Background Color', 'wp-simple-booking-calendar'),
                'settings' => 'header_dropdown_background_color',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('header_dropdown_background_color')->transport = 'postMessage';

        // Dropdown Text Color
        $wp_customize->add_setting(
            'header_dropdown_color',
            array(
                'default' => '#000',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_header_dropdown_color',
            array(
                'label' => __('Header - Dropdown Text Color', 'wp-simple-booking-calendar'),
                'settings' => 'header_dropdown_color',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('header_dropdown_color')->transport = 'postMessage';

        // Dropdown Text Color
        $wp_customize->add_setting(
            'header_dropdown_border_color',
            array(
                'default' => '#bdc3c7',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_header_dropdown_border_color',
            array(
                'label' => __('Header - Dropdown Border Color', 'wp-simple-booking-calendar'),
                'settings' => 'header_dropdown_border_color',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('header_dropdown_border_color')->transport = 'postMessage';

        // Calendar Background Color
        $wp_customize->add_setting(
            'calendar_background_color',
            array(
                'default' => '#fff',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_calendar_background_color',
            array(
                'label' => __('Calendar - Background Color', 'wp-simple-booking-calendar'),
                'settings' => 'calendar_background_color',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('calendar_background_color')->transport = 'postMessage';

        // Calendar Border Color
        $wp_customize->add_setting(
            'calendar_text_color',
            array(
                'default' => '#000',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_calendar_text_color',
            array(
                'label' => __('Calendar - Text Color', 'wp-simple-booking-calendar'),
                'settings' => 'calendar_text_color',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('calendar_text_color')->transport = 'postMessage';

        // Calendar Border Color
        $wp_customize->add_setting(
            'calendar_border_color',
            array(
                'default' => '#f1f1f1',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_calendar_border_color',
            array(
                'label' => __('Calendar - Border Color', 'wp-simple-booking-calendar'),
                'settings' => 'calendar_border_color',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('calendar_border_color')->transport = 'postMessage';

        // Date Padding Cells
        $wp_customize->add_setting(
            'dates_pad_cells',
            array(
                'default' => '#f7f7f7',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_dates_pad_cells',
            array(
                'label' => __('Dates - Other Month Dates Background', 'wp-simple-booking-calendar'),
                'settings' => 'dates_pad_cells',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('dates_pad_cells')->transport = 'postMessage';

        // Date Week Numbers
        $wp_customize->add_setting(
            'dates_weeknumbers',
            array(
                'default' => '#e8e8e8',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,
            'wpsbc_dates_weeknumbers',
            array(
                'label' => __('Dates - Week Numbers Background', 'wp-simple-booking-calendar'),
                'settings' => 'dates_weeknumbers',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('dates_weeknumbers')->transport = 'postMessage';

        // Date Border Radius
        $wp_customize->add_setting(
            'dates_border_radius',
            array(
                'default' => '0',
                'type' => 'theme_mod',
                'transport' => 'postMessage',
            )
        );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            'wpsbc_dates_border_radius',
            array(
                'type' => 'number',
                'label' => __('Dates - Border Radius', 'wp-simple-booking-calendar'),
                'settings' => 'dates_border_radius',
                'section' => 'wpsbc_calendar_options',
            )
        ));

        $wp_customize->get_setting('dates_border_radius')->transport = 'postMessage';
    }

    public static function header_output()
    {
        echo '<style type="text/css">'; {
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header', 'background-color', 'header_background_color', '', '');
            self::generate_css('.wpsbc-container .wpsbc-calendar-header', 'background-color', 'header_background_color');
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-prev', 'background-color', 'header_arrow_background_color', '', '');
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-prev .wpsbc-arrow', 'border-color', 'header_arrow_color', 'transparent ', ' transparent transparent', '', '');
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-next .wpsbc-arrow', 'border-color', 'header_arrow_color', 'transparent ', '',' transparent transparent', '');
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-next', 'background-color', 'header_arrow_background_color', '', '');
            self::generate_css('.wpsbc-container .wpsbc-calendar-header .wpsbc-calendar-header-navigation', 'color', 'header_text_color');
            self::generate_css('.wpsbc-container .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-next, .wpsbc-container .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-prev', 'background-color', 'header_arrow_background_color');
            self::generate_css('.wpsbc-container .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-prev .wpsbc-arrow', 'border-color', 'header_arrow_color', 'transparent ', ' transparent transparent');
            self::generate_css('.wpsbc-container .wpsbc-calendar-header .wpsbc-calendar-header-navigation .wpsbc-next .wpsbc-arrow', 'border-color', 'header_arrow_color', 'transparent transparent transparent ');
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-select-container select', 'background-color', 'header_dropdown_background_color');
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-select-container select', 'border-color', 'header_dropdown_border_color');
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar .wpsbc-calendar-header .wpsbc-select-container select', 'color', 'header_dropdown_color');

            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar, .wpsbc-legend, .wpsbc-yearly-calendar-row .wpsbc-yearly-calendar-row-header', 'background-color', 'calendar_background_color');
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar, .wpsbc-legend', 'border-color', 'calendar_border_color');
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar, .wpsbc-legend', 'color', 'calendar_text_color');

            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar table tr td .wpsbc-date.wpsbc-gap', 'background-color', 'dates_pad_cells');
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar table td .wpsbc-week-number', 'background-color', 'dates_weeknumbers');
            self::generate_css('.wpsbc-container .wpsbc-calendars .wpsbc-calendar table tr td .wpsbc-date, .wpsbc-container .wpsbc-calendars .wpsbc-calendar table td .wpsbc-week-number, .wpsbc-yearly-calendar-row-header-inner', 'border-radius', 'dates_border_radius', '', 'px');
        }
        echo '</style>';
    }

    public static function live_preview()
    {
        wp_register_script('wpsbc-customizer', WPSBC_PLUGIN_DIR_URL . 'assets/js/script-customizer.js', array('jquery', 'customize-preview'), WPSBC_VERSION);
        wp_enqueue_script('wpsbc-customizer');
    }

    public static function generate_css($selector, $style, $mod_name, $prefix = '', $suffix = '')
    {
        $mod = get_theme_mod($mod_name);
        if (!empty($mod)) {
            echo sprintf(
                ' %s { %s:%s; }',
                $selector,
                $style,
                $prefix . $mod . $suffix
            );
        }
    }
}

add_action('customize_register', array('WPSBC_Customize', 'register'));
add_action('wp_head', array('WPSBC_Customize', 'header_output'));
add_action('customize_preview_init', array('WPSBC_Customize', 'live_preview'));
