<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Ajax callback when the search form is submitted
 * 
 */
function wpsbc_ajax_search_calendars()
{
    check_ajax_referer('wpsbc_search_form', 'wpsbc_token');

    // Check args
    foreach ($_POST['args'] as $key => $val) {
        if (in_array($key, array_keys(wpsbc_get_search_widget_default_args()))) {
            $search_widget_args[$key] = sanitize_text_field($val);
        }
    }

    $search_widget_outputter = new wpsbc_Search_Widget_Outputter($search_widget_args, sanitize_text_field($_POST['start_date']), sanitize_text_field($_POST['end_date']));
    
    echo $search_widget_outputter->get_display();

    exit;
}

add_action('wp_ajax_wpsbc_search_calendars', 'wpsbc_ajax_search_calendars');
add_action('wp_ajax_nopriv_wpsbc_search_calendars', 'wpsbc_ajax_search_calendars');
