<?php
class WPSBC_Divi_Module_CalendarSearch extends ET_Builder_Module
{

    public $slug = 'wpsbc_divi_calendar_search';
    public $vb_support = 'on';

    public function init()
    {
        $this->name = esc_html__('Calendar Search', 'wp-simple-booking-calendar');
    }

    public function get_fields()
    {
      
        // Languages
        $languages_dropdown = array();
        $settings = get_option('wpsbc_settings', array());
        $languages = wpsbc_get_languages();
        $active_languages = (!empty($settings['active_languages']) ? $settings['active_languages'] : array());

        $languages_dropdown['auto'] = __('Auto (let WP choose)', 'wp-simple-booking-calendar');

        foreach ($active_languages as $code) {
            $languages_dropdown[esc_attr($code)] = (!empty($languages[$code]) ? $languages[$code] : '');
        }

        // Week Days
        $week_days = array(
            '1' => __('Monday', 'wp-simple-booking-calendar'),
            '2' => __('Tuesday', 'wp-simple-booking-calendar'),
            '3' => __('Wednesday', 'wp-simple-booking-calendar'),
            '4' => __('Thursday', 'wp-simple-booking-calendar'),
            '5' => __('Friday', 'wp-simple-booking-calendar'),
            '6' => __('Saturday', 'wp-simple-booking-calendar'),
            '7' => __('Sunday', 'wp-simple-booking-calendar'),
        );

        return array(
            

            'title' => array(
                'label' => esc_html__('Widget Title', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => 'yes',
                'option_category' => 'basic_option',
                'options' => array('yes' => __('Yes', 'wp-simple-booking-calendar'), 'no' => __('No', 'wp-simple-booking-calendar')),
            ),

            'start_day' => array(
                'label' => esc_html__('Week Start Day', 'wp-simple-booking-calendar-search'),
                'type' => 'select',
                'default' => '1',
                'option_category' => 'basic_option',
                'options' => $week_days,
            ),

            'selection_type' => array(
                'label' => esc_html__('Selection Type', 'wp-simple-booking-calendar-search'),
                'type' => 'select',
                'default' => 'multiple',
                'option_category' => 'basic_option',
                'options' => array('multiple' => __('Date Range', 'wp-simple-booking-calendar-search'), 'single' => __('Single Day', 'wp-simple-booking-calendar-search')),
            ),

            'minimum_stay' => array(
                'label' => esc_html__('Minimum Stay', 'wp-simple-booking-calendar-search'),
                'type' => 'text',
                'default' => '0',
                'option_category' => 'basic_option'
            ),

            'language' => array(
                'label' => esc_html__('Language', 'wp-simple-booking-calendar-search'),
                'type' => 'select',
                'default' => 'auto',
                'option_category' => 'basic_option',
                'options' => $languages_dropdown,
            ),

            'featured_image' => array(
                'label' => esc_html__('Show Featured Image', 'wp-simple-booking-calendar-search'),
                'type' => 'select',
                'default' => 'no',
                'option_category' => 'basic_option',
                'options' => array('yes' => __('Yes', 'wp-simple-booking-calendar-search'), 'no' => __('No', 'wp-simple-booking-calendar-search')),
            ),


            'show_results_on_load' => array(
                'label' => esc_html__('Show Results on Load', 'wp-simple-booking-calendar-search'),
                'type' => 'select',
                'default' => 'no',
                'option_category' => 'basic_option',
                'options' => array('yes' => __('Yes', 'wp-simple-booking-calendar-search'), 'no' => __('No', 'wp-simple-booking-calendar-search')),
            ),

            'results_layout' => array(
                'label' => esc_html__('Results Layout', 'wp-simple-booking-calendar-search'),
                'type' => 'select',
                'default' => 'list',
                'option_category' => 'basic_option',
                'options' => array('list' => __('List', 'wp-simple-booking-calendar-search'), 'grid' => __('Grid', 'wp-simple-booking-calendar-search')),
            ),

            'results_per_page' => array(
                'label' => esc_html__('Results per Page', 'wp-simple-booking-calendar-search'),
                'type' => 'text',
                'default' => '10',
                'option_category' => 'basic_option'
            ),

            'redirect' => array(
                'label' => esc_html__('Redirect', 'wp-simple-booking-calendar-search'),
                'type' => 'text',
                'default' => '',
                'option_category' => 'basic_option'
            ),

        );
    }

    public function render($attrs, $content = null, $render_slug = null)
    {
        // Execute the shortcode
        return WPSBC_Shortcodes::search_widget($this->props);
    }
}

new WPSBC_Divi_Module_CalendarSearch;
