jQuery(function ($) {

	/**
	 * Resizes the calendar to always have square dates
	 *
	 */
	function resize_calendar($calendars_wrapper) {

		/**
		 * Set variables
		 *
		 */
		var $months_wrapper = $calendars_wrapper.find('.wpsbc-calendars-wrapper');
		var $months_wrapper_width = $calendars_wrapper.find('.wpsbc-calendars');
		var calendar_min_width = $calendars_wrapper.data('min_width');
		var calendar_max_width = $calendars_wrapper.data('max_width');

		var $month_inner = $calendars_wrapper.find('.wpsbc-calendar-wrapper');

		/**
		 * Set the calendar months min and max width from the data attributes
		 *
		 */
		if ($calendars_wrapper.data('min_width') > 0)
			$calendars_wrapper.find('.wpsbc-calendar').css('min-width', calendar_min_width);

		if ($calendars_wrapper.data('max_width') > 0)
			$calendars_wrapper.find('.wpsbc-calendar').css('max-width', calendar_max_width)


		/**
		 * Set the column count
		 *
		 */
		var column_count = 0;

		if ($months_wrapper_width.width() < (10 + calendar_min_width) * 2)
			column_count = 1;

		else if ($months_wrapper_width.width() < (10 + calendar_min_width) * 3)
			column_count = 2;

		else if ($months_wrapper_width.width() < (10 + calendar_min_width) * 4)
			column_count = 3;

		else if ($months_wrapper_width.width() < (10 + calendar_min_width) * 6)
			column_count = 4;

		else
			column_count = 6;


		// Adjust for when there are fewer months in a calendar than columns
		if ($calendars_wrapper.find('.wpsbc-calendar').length <= column_count)
			column_count = $calendars_wrapper.find('.wpsbc-calendar').length;

		// Set column count
		$calendars_wrapper.attr('data-columns', column_count);


		/**
		 * Set the max-width of the calendars container that has a side legend
		 *
		 */
		if ($months_wrapper.hasClass('wpsbc-legend-position-side')) {

			$months_wrapper.css('max-width', 'none');
			$months_wrapper.css('max-width', $calendars_wrapper.find('.wpsbc-calendar').first().outerWidth(true) * column_count);

		}


		/**
		 * Handle the height of each date
		 *
		 */
		var td_width = $calendars_wrapper.find('td').first().width();

		$calendars_wrapper.find('td .wpsbc-date-inner, td .wpsbc-week-number').css('height', Math.ceil(td_width) + 1 + 'px');
		$calendars_wrapper.find('td .wpsbc-date-inner, td .wpsbc-week-number').css('line-height', Math.ceil(td_width) + 1 + 'px');

		var th_height = $calendars_wrapper.find('th').css('height', 'auto').first().height();
		$calendars_wrapper.find('th').css('height', Math.ceil(th_height) + 1 + 'px');

		/**
		 * Set calendar month height
		 *
		 */
		var calendar_month_height = 0;

		$month_inner.css('min-height', '1px');

		$month_inner.each(function () {

			if ($(this).height() >= calendar_month_height)
				calendar_month_height = $(this).height();

		});

		$month_inner.css('min-height', Math.ceil(calendar_month_height) + 'px');

		/**
		 * Show the calendars
		 *
		 */
		$calendars_wrapper.css('visibility', 'visible');

	}


	/**
	 * Resizes the calendar overview to overflow
	 *
	 */
	// Add min-height to calendar overview headings
	function resize_calendar_overview($calendar_container) {
		$calendar_container.find(".wpsbc-overview-row .wpsbc-overview-row-header").each(function () {
			$(this).parent().find('.wpsbc-calendar-wrapper .wpsbc-date').css('min-height', $(this).find('.wpsbc-overview-row-header-inner').outerHeight(true)).css('line-height', $(this).find('.wpsbc-overview-row-header-inner').outerHeight(true) + 'px');
		});
	}

	/**
	 * Refreshed the output of the calendar with the given data
	 *
	 */
	function refresh_calendar($calendar_container, current_year, current_month) {

		var $calendar_container = $calendar_container;

		if ($calendar_container.hasClass('wpsbc-is-loading'))
			return false;

		/**
		 * Prepare the calendar data
		 *
		 */
		var data = $calendar_container.data();

		data['action'] = 'wpsbc_refresh_calendar';
		data['current_year'] = current_year;
		data['current_month'] = current_month;

		/**
		 * Add loading animation
		 *
		 */
		$calendar_container.find('.wpsbc-calendar').append('<div class="wpsbc-overlay"><div class="wpsbc-overlay-spinner"><div class="wpsbc-overlay-bounce1"></div><div class="wpsbc-overlay-bounce2"></div><div class="wpsbc-overlay-bounce3"></div></div></div>');
		$calendar_container.addClass('wpsbc-is-loading');
		$calendar_container.find('select').attr('disabled', true);


		/**
		 * Make the request
		 *
		 */
		$.post(wpsbc.ajax_url, data, function (response) {

			$calendar_container.replaceWith(response);

			$('.wpsbc-container').each(function () {
				resize_calendar($(this));
			});

		});

	}

	$(document).on('wpsbc_refresh_calendars', function () {
		$('.wpsbc-container').each(function () {
			refresh_calendar($(this), $(this).data('current_year'), $(this).data('current_month'));
		})
	});


	/**
	 * Refreshed the output of the calendar with the given data
	 *
	 */
	function refresh_calendar_overview($calendar_container, current_year, current_month) {

		var $calendar_container = $calendar_container;

		if ($calendar_container.hasClass('wpsbc-is-loading'))
			return false;

		/**
		 * Prepare the calendar data
		 *
		 */
		var data = $calendar_container.data();

		data['action'] = 'wpsbc_refresh_calendar_overview';
		data['current_year'] = current_year;
		data['current_month'] = current_month;

		/**
		 * Add loading animation
		 *
		 */
		$calendar_container.find('.wpsbc-overview-inner').append('<div class="wpsbc-overlay"><div class="wpsbc-overlay-spinner"><div class="wpsbc-overlay-bounce1"></div><div class="wpsbc-overlay-bounce2"></div><div class="wpsbc-overlay-bounce3"></div></div></div>');
		$calendar_container.addClass('wpsbc-is-loading');
		$calendar_container.find('select').attr('disabled', true);

		/**
		 * Make the request
		 *
		 */
		$.post(wpsbc.ajax_url, data, function (response) {

			$calendar_container.replaceWith(response);

			$('.wpsbc-overview-container').each(function () {
				resize_calendar_overview($(this));
			});

		});

	}


	/**
	 * Resize the calendars on page load
	 *
	 */
	$('.wpsbc-container').each(function () {
		resize_calendar($(this));
	});

	/**
	 * Resize the calendars on page resize
	 *
	 */
	$(window).on('resize', function () {

		$('.wpsbc-container').each(function () {
			resize_calendar($(this));
		});

	});


	/**
	 * Handles the navigation of the Previous button
	 *
	 */
	$(document).on('click', '.wpsbc-container .wpsbc-prev', function (e) {

		e.preventDefault();

		// Set container
		var $container = $(this).closest('.wpsbc-container');

		// Set the current year and month that are displayed in the calendar
		var current_month = $container.data('current_month');
		var current_year = $container.data('current_year');

		// Calculate the 
		var navigate_count = 1;

		// Take into account jump months option
		if (typeof $container.data('jump_months') != 'undefined' && $container.data('jump_months') == '1') {
			navigate_count = parseInt((wpsbc.calendar_months_to_jump ? wpsbc.calendar_months_to_jump : $container.data('months_to_show')));
		}

		for (var i = 1; i <= navigate_count; i++) {

			current_month -= 1;

			if (current_month < 1) {
				current_month = 12;
				current_year -= 1;
			}

		}

		refresh_calendar($container, current_year, current_month);

	});

	/**
	 * Handles the navigation of the Next button
	 *
	 */
	$(document).on('click', '.wpsbc-container .wpsbc-next', function (e) {

		e.preventDefault();

		// Set container
		var $container = $(this).closest('.wpsbc-container');

		// Set the current year and month that are displayed in the calendar
		var current_month = $container.data('current_month');
		var current_year = $container.data('current_year');

		// Calculate the 
		var navigate_count = 1;

		// Take into account jump months option
		if (typeof $container.data('jump_months') != 'undefined' && $container.data('jump_months') == '1') {
			navigate_count = parseInt((wpsbc.calendar_months_to_jump ? wpsbc.calendar_months_to_jump : $container.data('months_to_show')));
		}

		for (var i = 1; i <= navigate_count; i++) {

			current_month += 1;

			if (current_month > 12) {
				current_month = 1;
				current_year += 1;
			}

		}

		refresh_calendar($container, current_year, current_month);

	});

	/**
	 * Handles the navigation of the Month Selector for the Single Calendar
	 *
	 */
	$(document).on('change', '.wpsbc-container .wpsbc-select-container select', function () {

		// Set container
		var $container = $(this).closest('.wpsbc-container');

		var date = new Date($(this).val() * 1000);

		var year = date.getFullYear();
		var month = date.getMonth() + 1;

		refresh_calendar($container, year, month);

	});


	/**
	 * Handles the navigation of the Month Selector for the Calendar Overview
	 *
	 */
	$(document).on('change', '.wpsbc-overview-container .wpsbc-select-container select', function () {

		// Set container
		var $container = $(this).closest('.wpsbc-overview-container');

		var date = new Date($(this).val() * 1000);

		var year = date.getFullYear();
		var month = date.getMonth() + 1;

		refresh_calendar_overview($container, year, month);

	});


	/**
	 * Handles display of the tooltip
	 *
	 */
	$(document).on('mouseenter touchstart', '.wpsbc-container .wpsbc-date, .wpsbc-overview-container .wpsbc-date', function () {

		var $date = $(this);

		if (!$date.find('.wpsbc-tooltip').length)
			return;

		var $tooltip = $date.find('.wpsbc-tooltip');

		/**
		 * Position Tooltip
		 * 
		 */

		var offset_left;

		// Get the right overflow
		var overflow_right = $(window).width() - ($date.offset().left + $tooltip.outerWidth(true));

		// Does it overflow in the RHS?
		if (overflow_right < 0) {
			//Get the left overflow
			overflow_left = 0 - ($tooltip.outerWidth(true) - $date.offset().left);
			// Does it overflow in the LHS as well? On which site is the overflow greater? 
			if (overflow_left < 0 && overflow_right > overflow_left) {
				// Overflows more in the left
				offset_left = $date.offset().left;
			} else {
				// Overflows more in the right
				offset_left = $date.offset().left - $tooltip.outerWidth(true) + $date.outerWidth(true);
			}
		} else {
			// It doesn't overflow.
			offset_left = $date.offset().left;
		}

		$tooltip.css('left', offset_left);
		$tooltip.css('top', $date.offset().top - $tooltip.outerHeight() - $(window).scrollTop() - 2);

		$date.addClass('wpsbc-tooltip-active');

	});

	/**
	 * Hide the tooltip when scrolling
	 * 
	 */
	$(window).on('scroll', function () {
		if (!$(".wpsbc-tooltip-active").length) {
			return;
		}

		$(".wpsbc-tooltip-active").removeClass('wpsbc-tooltip-active');
	})

	/**
	 * Handle hiding of the tooltip
	 *
	 */
	$(document).on('mouseleave', '.wpsbc-container .wpsbc-date, .wpsbc-overview-container .wpsbc-date', function () {

		var $date = $(this);

		if (!$date.find('.wpsbc-tooltip').length)
			return;

		$date.removeClass('wpsbc-tooltip-active');

	});

	/**
	 * Handle the initialization of the Overview Calendars
	 *
	 */
	$('.wpsbc-overview-container').each(function () {
		resize_calendar_overview($(this));
	});

	/**
	 * Resize the calendars on page resize
	 *
	 */
	$(window).on('resize', function () {

		$('.wpsbc-overview-container').each(function () {
			resize_calendar_overview($(this));
		});

	});

	/**
	 * Check if a calendar is hidden and wait for it to become visible. 
	 * When it does, trigger a window resize to properly display the calendar.
	 * 
	 */
	var wpsbc_frontend_visible_calendars = $('.wpsbc-container:visible').length;
	function wpsbc_check_if_calendar_is_visible() {

		// If no calendars are embedded, exit
		if (!$('.wpsbc-container').length)
			return false;

		// Add .visible class
		$('.wpsbc-container:visible').addClass('wpsbc-visible');

		// If a calendar just became visible, trigger a resize
		if (wpsbc_frontend_visible_calendars != $('.wpsbc-container.wpsbc-visible').length) {
			$(window).trigger('resize');
			wpsbc_frontend_visible_calendars = $('.wpsbc-container.wpsbc-visible').length;
		}

		// Remove .visible class
		$('.wpsbc-container:not(:visible)').removeClass('wpsbc-visible');

		// If all calendars are visible, exit
		if ($('.wpsbc-container.wpsbc-visible').length == $('.wpsbc-container').length) {
			return false;
		}

		// Keep checking every 250ms
		setTimeout(wpsbc_check_if_calendar_is_visible, 250);

	}
	// Manually start the first check
	wpsbc_check_if_calendar_is_visible();

	/**
	 * Search Widget
	 * 
	 */
	$(document).ready(function () {
		/**
		 * The datepickers
		 * 
		 */
		wpsbc_search_widget_initialize_datepickers();

		wpsbc_search_widget_pagination();

		$(document).on('click', ".wpsbc-search-widget-datepicker-submit", function (e) {
			e.preventDefault();

			var $button = $(this);
			var $container = $button.parents('.wpsbc-search-widget');
			var $form = $container.find('.wpsbc-search-widget-form');

			if ($container.data('redirect')) {
				$form.submit();
				return false;
			}

			$form.addClass('wpsbc-searching');
			$button.prop('disabled', true);

			$(".wpsbc-search-widget-results-wrap").empty();
			$(".wpsbc-search-widget-error-field").empty();

			var data = {
				action: 'wpsbc_search_calendars',
				start_date: $form.find('.wpsbc-search-widget-datepicker-standard-format-start-date').val(),
				end_date: $form.find('.wpsbc-search-widget-datepicker-standard-format-end-date').val(),
				args: $container.data(),
				wpsbc_token: wpsbc.search_form_nonce
			}

			$.post(wpsbc.ajax_url, data, function (response) {
				$form.removeClass('wpsbc-searching');
				$button.prop('disabled', false);

				$container.replaceWith(response)
				wpsbc_search_widget_initialize_datepickers();

				wpsbc_pagination_total = $(".wpsbc-search-widget-result").length;
				wpsbc_pagination_pages = Math.ceil(wpsbc_pagination_total / wpsbc_pagination_ppp);
				wpsbc_pagination_current_page = 0;

				wpsbc_search_widget_pagination();

				// Add padding to form
				wpsbc_search_widget_add_padding();
				wpsbc_search_widget_size();

				$(".wpsbc-search-widget").animate({ opacity: 1 }, 200);

				// Resize the results on page resize
				$('.wpsbc-search-widget').each(function () {
					resize_search_widget($(this));
				});
			});
		});


		// Add padding to form
		wpsbc_search_widget_add_padding();
		wpsbc_search_widget_size();

		$(window).on('load', function () {
			$(".wpsbc-search-widget").animate({ opacity: 1 }, 200);
		});


		$(window).bind('load resize', function () {
			// Add padding to form
			wpsbc_search_widget_add_padding();
			wpsbc_search_widget_size();
		});

		/**
		 * Resizes the results
		 *
		 */
		function resize_search_widget($results_wrapper) {

			/**
			 * Set variables
			 *
			 */
			var $results_wrapper_width = $results_wrapper.find('.wpsbc-search-widget-results');
			var results_min_width = 250;
			var results_max_width = 500;


			/**
			 * Set the results min and max width from the data attributes
			 *
			 */
			$results_wrapper.find('.wpsbc-search-widget-result').css('min-width', results_min_width);

			$results_wrapper.find('.wpsbc-search-widget-result').css('max-width', results_max_width)


			/**
			 * Set the column count
			 *
			 */
			var column_count = 0;

			if ($results_wrapper_width.width() < (10 + results_min_width) * 2)
				column_count = 1;

			else if ($results_wrapper_width.width() < (10 + results_min_width) * 3)
				column_count = 2;

			else if ($results_wrapper_width.width() < (10 + results_min_width) * 4)
				column_count = 3;

			else if ($results_wrapper_width.width() < (10 + results_min_width) * 6)
				column_count = 4;
			else
				column_count = 6;


			// Adjust for when there are fewer months in a calendar than columns
			if ($results_wrapper.find('.wpsbc-search-widget-result').length <= column_count)
				column_count = $results_wrapper.find('.wpsbc-search-widget-result').length;

			// Set column count
			$results_wrapper.attr('data-columns', column_count);
		}


		/**
		 * Resize the results on page load
		 *
		 */
		$('.wpsbc-search-widget').each(function () {
			resize_search_widget($(this));
		});

		/**
		 * Resize the results on page resize
		 *
		 */
		$(window).on('resize', function () {
			$('.wpsbc-search-widget').each(function () {
				resize_search_widget($(this));
			});
		});

	});

	/**
	 * Add padding to make the "Search" button fit properly.
	 * 
	 */
	function wpsbc_search_widget_add_padding() {
		$(".wpsbc-search-widget .wpsbc-search-widget-form").css('padding-right', $(".wpsbc-search-widget .wpsbc-search-widget-form .wpsbc-search-widget-field.wpsbc-search-widget-field-submit").width());
	};

	/**
	 * Dynamically resize the search widget
	 * 
	 */
	function wpsbc_search_widget_size() {
		$(".wpsbc-search-widget").each(function () {
			$widget = $(this);
			if ($widget.width() < 500) {
				$widget.addClass('wpsbc-search-widget-small');
			} else {
				$widget.removeClass('wpsbc-search-widget-small');
			};
		});
	};

	/**
	 * Search Widget pagination
	 * 
	 */
	var wpsbc_pagination_ppp = Math.abs($(".wpsbc-search-widget").data('results_per_page')) > 0 ? Math.abs($(".wpsbc-search-widget").data('results_per_page')) : 10;
	var wpsbc_pagination_total = $(".wpsbc-search-widget-result").length;
	var wpsbc_pagination_pages = Math.ceil(wpsbc_pagination_total / wpsbc_pagination_ppp);
	var wpsbc_pagination_current_page = 0;

	function wpsbc_search_widget_pagination() {

		$(".wpsbc-search-widget-result").hide();

		$(".wpsbc-search-widget-result").slice(wpsbc_pagination_current_page * wpsbc_pagination_ppp, (wpsbc_pagination_current_page + 1) * wpsbc_pagination_ppp).show();

		if (wpsbc_pagination_total > wpsbc_pagination_ppp) {
			$(".wpsbc-search-pagination").remove();
			$(".wpsbc-search-widget-results-wrap").append('<div class="wpsbc-search-pagination"><ul></ul></div>');

			$('.wpsbc-search-pagination ul').append('<li><a ' + (wpsbc_pagination_current_page == 0 ? 'class="wpsbc-pagination-disabled"' : '') + ' href="#" data-page="previous">' + $('.wpsbc-search-widget-results-wrap').data('label-previous') + '</a></li>');

			for (i = 0; i < wpsbc_pagination_pages; i++) {
				$('.wpsbc-search-pagination ul').append('<li><a ' + (wpsbc_pagination_current_page == i ? 'class="wpsbc-pagination-active"' : '') + ' href="#" data-page="' + i + '">' + (i + 1) + '</a></li>');
			}

			$('.wpsbc-search-pagination ul').append('<li><a ' + (wpsbc_pagination_current_page == (wpsbc_pagination_pages - 1) ? 'class="wpsbc-pagination-disabled"' : '') + ' href="#" data-page="next">' + $('.wpsbc-search-widget-results-wrap').data('label-next') + '</a></li>');
		}
	}

	$("body").on('click', '.wpsbc-search-pagination li a', function (e) {
		e.preventDefault();

		if ($(this).hasClass('wpsbc-pagination-disabled')) {
			return false;
		}

		var page = $(this).data('page');

		if (page == 'next' && wpsbc_pagination_current_page != (wpsbc_pagination_pages - 1)) {
			page = wpsbc_pagination_current_page + 1;
		}
		if (page == 'previous' && wpsbc_pagination_current_page != 0) {
			page = wpsbc_pagination_current_page - 1;
		}

		wpsbc_pagination_current_page = page;

		wpsbc_search_widget_pagination();
	});

	/**
	 * Initialize search widget datepickers
	 * 
	 */
	function wpsbc_search_widget_initialize_datepickers() {

		if ($('body').hasClass('wp-admin')) return false;

		// Prevent conflicts with Bootstrap Datepicker
		if (typeof $.fn.datepicker.noConflict === 'function') {
			$.fn.datepicker.noConflict();
		}

		var wpsbc_s_start_day = $(".wpsbc-search-widget").data('start_day') ? $(".wpsbc-search-widget").data('start_day') : 1;

		var start_date = $(".wpsbc-search-widget-datepicker-start-date").datepicker({
			changeMonth: true,
			changeYear: true,
			dateFormat: wpsbc.search_date_format,
			firstDay: wpsbc_s_start_day,
			minDate: 0,
			altFormat: 'yy-m-d',
			altField: $('.wpsbc-search-widget-datepicker-standard-format-start-date'),
			showOtherMonths: true,
			selectOtherMonths: true,
			beforeShow: function () {
				$('#ui-datepicker-div').addClass('wpsbc-datepicker');
			},
			onClose: function () {
				$('#ui-datepicker-div').hide().removeClass('wpsbc-datepicker');
				$(".wpsbc-search-widget-datepicker-end-date").focus();
			},
		}).on("change", function () {
			end_date.datepicker("option", "minDate", wpsbc_datepicker_get_date(this, $(".wpsbc-search-widget").data('minimum_stay')));

			if (!$(".wpsbc-search-widget").data('redirect')) {
				wpsbc_datepicker_update_state('wpsbc-search-start-date', $(".wpsbc-search-widget-datepicker-standard-format-start-date").val())
			}

		})

		var end_date = $(".wpsbc-search-widget-datepicker-end-date").datepicker({
			changeMonth: true,
			changeYear: true,
			dateFormat: wpsbc.search_date_format,
			firstDay: wpsbc_s_start_day,
			minDate: wpsbc_datepicker_get_date($(".wpsbc-search-widget-datepicker-start-date")[0], $(".wpsbc-search-widget").data('minimum_stay')),
			altFormat: 'yy-m-d',
			altField: $('.wpsbc-search-widget-datepicker-standard-format-end-date'),
			showOtherMonths: true,
			selectOtherMonths: true,
			beforeShow: function () {
				$('#ui-datepicker-div').addClass('wpsbc-datepicker');
			},
			onClose: function () {
				$('#ui-datepicker-div').hide().removeClass('wpsbc-datepicker');
			},
		}).on("change", function () {
			if (!$(".wpsbc-search-widget").data('redirect')) {
				wpsbc_datepicker_update_state('wpsbc-search-end-date', $(".wpsbc-search-widget-datepicker-standard-format-end-date").val())
			}
		});
	};


	/**
	 * Helper function to change the url history state
	 * 
	 * @param key 
	 * @param value 
	 */
	function wpsbc_datepicker_update_state(key, value) {
		var baseUrl = [location.protocol, '//', location.host, location.pathname].join(''),
			urlQueryString = document.location.search,
			newParam = key + '=' + value,
			params = '?' + newParam;

		// If the "search" string exists, then build params from it
		if (urlQueryString) {
			keyRegex = new RegExp('([\?&])' + key + '[^&]*');

			// If param exists already, update it
			if (urlQueryString.match(keyRegex) !== null) {
				params = urlQueryString.replace(keyRegex, "$1" + newParam);
			} else { // Otherwise, add it to end of query string
				params = urlQueryString + '&' + newParam;
			}
		}
		window.history.replaceState({}, "", baseUrl + params);
	};

	/**
	 * Helper function to get the date of a datepicker element
	 * 
	 */
	function wpsbc_datepicker_get_date(element, offset) {
		var date;
		try {
			date = $.datepicker.parseDate(wpsbc.search_date_format, element.value);
		} catch (error) {
			date = null;
		}

		if (offset !== false && date !== null) {
			date.setDate(date.getDate() + offset);
		}

		return date;
	};

	/**
	 * Elementor element resize
	 * 
	 */
	if ($('body').hasClass('elementor-editor-active')) {

		/**
		 * Runs every 250 milliseconds to check if a calendar was just loaded
		 * and if it was, trigger the window resize to show it
		 *
		 */
		setInterval(function () {

			$('.wpsbc-container-loaded').each(function () {

				if ($(this).attr('data-just-loaded') == '1') {
					$(window).trigger('resize');
					$(this).attr('data-just-loaded', '0');
				}

			});

		}, 250);

	}

	/**
	 * Elementor trigger resize after popup opens, if by any chance the calendar is in a popup.
	 * 
	 */
	$(document).on('elementor/popup/show', () => {
		$(window).trigger('resize');
		setTimeout(function () {
			$(window).trigger('resize');
		}, 10);
	});


});


