<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

?>


<?php

	/**
	 * Hook to add extra fields at the top of the General Tab
	 *
	 * @param array $settings
	 *
	 */
	do_action( 'wpsbc_submenu_page_settings_tab_general_top', $settings );

?>


<!-- Booking History Color -->
<div class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline">

	<label class="wpsbc-settings-field-label"><?php echo __( 'Booking History Color', 'wp-simple-booking-calendar' ); ?></label>

	<div class="wpsbc-settings-field-inner">
		<input name="wpsbc_settings[booking_history_color]" type="text" class="wpsbc-colorpicker" value="<?php echo ( ! empty( $settings['booking_history_color'] ) ? esc_attr( $settings['booking_history_color'] ) : '' ); ?>" />
	</div>
	
</div>

<!-- Current Day Color -->
<div class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline">

	<label class="wpsbc-settings-field-label"><?php echo __( 'Current Day Color', 'wp-simple-booking-calendar' ); ?></label>

	<div class="wpsbc-settings-field-inner">
		<input name="wpsbc_settings[current_day_color]" type="text" class="wpsbc-colorpicker" value="<?php echo ( ! empty( $settings['current_day_color'] ) ? esc_attr( $settings['current_day_color'] ) : '' ); ?>" />
	</div>
	
</div>


<!-- Calendar Back-end Start Day -->
<div class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline wpsbc-settings-field-small">

	<label class="wpsbc-settings-field-label"><?php echo __( 'Backend Start Day', 'wp-simple-booking-calendar' ); ?></label>

	<div class="wpsbc-settings-field-inner">
		<select name="wpsbc_settings[backend_start_day]">
			<?php 

				$weekday = wpsbc_get_weekdays();

				foreach( $weekday as $key => $day_name ) {

					// Weekdays keys start at 1, not 0
					$key++;

					echo '<option value="' . esc_attr( $key ) . '" ' . ( ! empty( $settings['backend_start_day'] ) ? selected( $settings['backend_start_day'], $key, false ) : '' ) . '>' . $day_name . '</option>';

				}

			?>
		</select>
	</div>
	
</div>


<!-- iCal Refresh Times -->
<div id="wpsbc-settings-field-ical-refresh-times-wrapper" class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline wpsbc-settings-field-medium">

	<label class="wpsbc-settings-field-label"><?php echo __( 'iCal Refresh Times', 'wp-simple-booking-calendar' ); ?></label>

	<div class="wpsbc-settings-field-inner">
		<select name="wpsbc_settings[ical_refresh_times]">
			<?php $selected = ( ! empty( $settings['ical_refresh_times'] ) ? $settings['ical_refresh_times'] : 'page_load' ); ?>
			<option value="page_load" <?php selected( $selected, 'page_load' ); ?>><?php echo __( 'On each page load', 'wp-simple-booking-calendar' ); ?></option>
			<option value="hourly" <?php selected( $selected, 'hourly' ); ?>><?php echo __( 'Hourly', 'wp-simple-booking-calendar' ); ?></option>
			<option value="daily" <?php selected( $selected, 'daily' ); ?>><?php echo __( 'Daily', 'wp-simple-booking-calendar' ); ?></option>
			<option value="custom" <?php selected( $selected, 'custom' ); ?>><?php echo __( 'Custom', 'wp-simple-booking-calendar' ); ?></option>
		</select>
	</div>

</div>

<!-- Custom iCal Refresh Times -->
<div id="wpsbc-settings-field-ical-custom-refresh-time-wrapper" class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline wpsbc-settings-field-medium">

	<label class="wpsbc-settings-field-label"><?php echo __( 'iCal Custom Refresh Time', 'wp-simple-booking-calendar' ); ?></label>

	<div class="wpsbc-settings-field-inner">

		<input name="wpsbc_settings[ical_custom_refresh_time]" type="number" value="<?php echo ( ! empty( $settings['ical_custom_refresh_time'] ) ? esc_attr( $settings['ical_custom_refresh_time'] ) : '' ); ?>" />

		<select name="wpsbc_settings[ical_custom_refresh_time_unit]">
			<?php $selected = ( ! empty( $settings['ical_custom_refresh_time_unit'] ) ? $settings['ical_custom_refresh_time_unit'] : 'page_load' ); ?>
			<option value="minutes" <?php selected( $selected, 'minutes' ); ?>><?php echo __( 'Minutes', 'wp-simple-booking-calendar' ); ?></option>
			<option value="hours" <?php selected( $selected, 'hours' ); ?>><?php echo __( 'Hours', 'wp-simple-booking-calendar' ); ?></option>
		</select>

	</div>

</div>

<?php

	/**
	 * Hook to add extra fields at the bottom of the General Tab
	 *
	 * @param array $settings
	 *
	 */
	do_action( 'wpsbc_submenu_page_settings_tab_general_bottom', $settings );

?>

<!-- Submit button -->
<input type="submit" class="button-primary" value="<?php echo __( 'Save Settings', 'wp-simple-booking-calendar' ); ?>" />