<?php
$start_date = '';
if (!is_null($this->start_date) && $start_date = DateTime::createFromFormat('Y-m-d', $this->start_date)) {
    $start_date = date_i18n(get_option('date_format'), $start_date->format('U'));
}

$end_date = '';
if (!is_null($this->end_date) && $end_date = DateTime::createFromFormat('Y-m-d', $this->end_date)) {
    $end_date = date_i18n(get_option('date_format'), $end_date->format('U'));
}


$fields_count = 1;
if($this->get_search_type() == 'multiple'){
    $fields_count += 1;
}
?>

<?php if ($this->args['title'] == 'yes'): ?>
    <h2><?php echo $this->get_search_widget_string('widget_title'); ?></h2>
<?php endif; ?>

<form action="<?php echo $this->args['redirect'] ?: '#'; ?>" method="GET" class="wpsbc-search-widget-form wpsbc-search-widget-form-fields-<?php echo $fields_count;?>" autocomplete="off">

    <div class="wpsbc-search-widget-field wpsbc-search-widget-field-start-date">
        <label for="wpsbc-search-widget-datepicker-start-date"><?php echo $this->get_search_widget_string('start_date_label'); ?></label>
        <input type="text" placeholder="<?php echo $this->get_search_widget_string('start_date_placeholder'); ?>" value="<?php echo $start_date; ?>" id="wpsbc-search-widget-datepicker-start-date" class="wpsbc-search-widget-datepicker wpsbc-search-widget-datepicker-start-date" name="start-date" readonly />
        <input type="hidden" value="<?php echo (!is_null($this->start_date)) ? $this->start_date : ''; ?>" id="wpsbc-search-widget-datepicker-standard-format-start-date" class="wpsbc-search-widget-datepicker-standard-format-start-date" name="wpsbc-search-start-date" />
    </div>

    <?php if ($this->get_search_type() == 'multiple'): ?>

        <div class="wpsbc-search-widget-field wpsbc-search-widget-field-end-date">
            <label for="wpsbc-search-widget-datepicker-end-date"><?php echo $this->get_search_widget_string('end_date_label'); ?></label>
            <input type="text" placeholder="<?php echo $this->get_search_widget_string('end_date_placeholder'); ?>" value="<?php echo $end_date; ?>" id="wpsbc-search-widget-datepicker-end-date" class="wpsbc-search-widget-datepicker wpsbc-search-widget-datepicker-end-date" name="end-date" readonly />
            <input type="hidden" value="<?php echo (!is_null($this->end_date)) ? $this->end_date : ''; ?>" id="wpsbc-search-widget-datepicker-standard-format-end-date" class="wpsbc-search-widget-datepicker-standard-format-end-date" name="wpsbc-search-end-date" />
        </div>

    <?php endif; ?>

    <div class="wpsbc-search-widget-field wpsbc-search-widget-field-submit">
        <button class="wpsbc-search-widget-datepicker-submit"><?php echo $this->get_search_widget_string('search_button_label'); ?></button>
    </div>

</form>