import React from 'react';
import Select from 'react-select';

const { ServerSideRender, PanelBody, SelectControl } = wp.components;

const { registerBlockType } = wp.blocks;
const { InspectorControls } = wp.editor;
const { __ } = wp.i18n;


/**
 * Block inspector controls options
 *
 */

// The options for the Calendars dropdown
var calendars = [];
if (typeof wpsbc_calendars !== 'undefined') {
    for (var i = 0; i < wpsbc_calendars.length; i++) {

        var calendar_name = jQuery('<textarea />').html(wpsbc_calendars[i].name).text();
        calendars.push({ value: wpsbc_calendars[i].id, label: calendar_name });

    }
}

// The options for the Months to Display dropdown
var months_to_display = [];

for (var i = 1; i <= 12; i++) {

    months_to_display.push({ value: i, label: i });

}

// The options for the Start Year dropdown
var start_year = [];
var current_date = new Date();

start_year[0] = { value: 0, label: __('Current Year', 'wp-simple-booking-calendar') };

for (var i = current_date.getFullYear(); i <= current_date.getFullYear() + 10; i++) {

    start_year.push({ value: i, label: i });

}

// The options for the Start Month dropdown
var start_month = [];
var month_names = [
    __('January', 'wp-simple-booking-calendar'),
    __('February', 'wp-simple-booking-calendar'),
    __('March', 'wp-simple-booking-calendar'),
    __('April', 'wp-simple-booking-calendar'),
    __('May', 'wp-simple-booking-calendar'),
    __('June', 'wp-simple-booking-calendar'),
    __('July', 'wp-simple-booking-calendar'),
    __('August', 'wp-simple-booking-calendar'),
    __('September', 'wp-simple-booking-calendar'),
    __('October', 'wp-simple-booking-calendar'),
    __('November', 'wp-simple-booking-calendar'),
    __('December', 'wp-simple-booking-calendar')
];

start_month[0] = { value: 0, label: __('Current Month', 'wp-simple-booking-calendar') };

for (var i = 1; i <= 12; i++) {

    start_month.push({ value: i, label: month_names[i - 1] });

}

// The option for the Language dropdown
var languages = [];

languages[0] = { value: 'auto', label: __('Auto', 'wp-simple-booking-calendar') };

for (var i = 0; i < wpsbc_languages.length; i++) {

    languages.push({ value: wpsbc_languages[i].code, label: wpsbc_languages[i].name });

}

// Register the block
registerBlockType('wp-simple-booking-calendar/overview-calendar', {

    // The block's title
    title: 'Multiple Overview Calendar',

    // The block's icon
    icon: 'calendar',

    // The block category the block should be added to
    category: 'wp-simple-booking-calendar',

    // The block's attributes, needed to save the data
    attributes: {

        calendars: {
            type: 'string',
            default: null
        },

        legend: {
            type: 'string'
        },

        legend_position: {
            type: 'string'
        },

        start_year: {
            type: 'string'
        },

        start_month: {
            type: 'string'
        },

        history: {
            type: 'string'
        },

        tooltip: {
            type: 'string'
        },

        weeknumbers: {
            type: 'string',
            default: 'no'
        },

        language: {
            type: 'string',
            default: 'auto'
        }

    },

    edit: function (props) {

        const selected = (typeof props.attributes.calendars != 'undefined' ? JSON.parse(props.attributes.calendars) : {})
        const handleSelectChange = (calendars) => props.setAttributes({ calendars: JSON.stringify(calendars) });

        return [

            <ServerSideRender
                block="wp-simple-booking-calendar/overview-calendar"
                attributes={props.attributes} />,

            <InspectorControls key="inspector">

                <PanelBody
                    title={__('Calendars', 'wp-simple-booking-calendar')}
                    initialOpen={true} >

                    <Select
                        label={__('Calendars', 'wp-simple-booking-calendar')}
                        name='select-two'
                        value={selected}
                        onChange={handleSelectChange}
                        options={calendars}
                        isMulti='true' />

                    <p class="description">{__('Select the calendars you wish to display in the overview, or leave empty to show all calendars.', 'wp-simple-booking-calendar')}</p>

                </PanelBody>

                <PanelBody
                    title={__('Calendar Basic Options', 'wp-simple-booking-calendar')}
                    initialOpen={true} >

                    <SelectControl
                        label={__('Display Legend', 'wp-simple-booking-calendar')}
                        value={props.attributes.legend}
                        options={[
                            { value: 'yes', label: __('Yes', 'wp-simple-booking-calendar') },
                            { value: 'no', label: __('No', 'wp-simple-booking-calendar') }
                        ]}
                        onChange={(new_value) => props.setAttributes({ legend: new_value })} />

                    <SelectControl
                        label={__('Legend Position', 'wp-simple-booking-calendar')}
                        value={props.attributes.legend_position}
                        options={[
                            { value: 'top', label: __('Top', 'wp-simple-booking-calendar') },
                            { value: 'bottom', label: __('Bottom', 'wp-simple-booking-calendar') }
                        ]}
                        onChange={(new_value) => props.setAttributes({ legend_position: new_value })} />

                    <SelectControl
                        label={__('Start Year', 'wp-simple-booking-calendar')}
                        value={props.attributes.start_year}
                        options={start_year}
                        onChange={(new_value) => props.setAttributes({ start_year: new_value })} />

                    <SelectControl
                        label={__('Start Month', 'wp-simple-booking-calendar')}
                        value={props.attributes.start_month}
                        options={start_month}
                        onChange={(new_value) => props.setAttributes({ start_month: new_value })} />

                </PanelBody>


                <PanelBody
                    title={__('Calendar Advanced Options', 'wp-simple-booking-calendar')}
                    initialOpen={true} >

                    <SelectControl
                        label={__('Show History', 'wp-simple-booking-calendar')}
                        value={props.attributes.history}
                        options={[
                            { value: '1', label: __('Display booking history', 'wp-simple-booking-calendar') },
                            { value: '2', label: __('Replace booking history with the default legend item', 'wp-simple-booking-calendar') },
                            { value: '3', label: __('Use the Booking History Color from the Settings', 'wp-simple-booking-calendar') }
                        ]}
                        onChange={(new_value) => props.setAttributes({ history: new_value })} />

                    <SelectControl
                        label={__('Display Tooltips', 'wp-simple-booking-calendar')}
                        value={props.attributes.tooltip}
                        options={[
                            { value: '1', label: __('No', 'wp-simple-booking-calendar') },
                            { value: '2', label: __('Yes', 'wp-simple-booking-calendar') },
                            { value: '3', label: __('Yes, with red indicator', 'wp-simple-booking-calendar') }
                        ]}
                        onChange={(new_value) => props.setAttributes({ tooltip: new_value })} />

                    <SelectControl
                        label={__('Show Weekday Abbreviations', 'wp-simple-booking-calendar')}
                        value={props.attributes.weeknumbers}
                        options={[
                            { value: 'yes', label: __('Yes', 'wp-simple-booking-calendar') },
                            { value: 'no', label: __('No', 'wp-simple-booking-calendar') }
                        ]}
                        onChange={(new_value) => props.setAttributes({ weeknumbers: new_value })} />

                    <SelectControl
                        label={__('Language', 'wp-simple-booking-calendar')}
                        value={props.attributes.language}
                        options={languages}
                        onChange={(new_value) => props.setAttributes({ language: new_value })} />

                </PanelBody>

            </InspectorControls>
        ];
    },

    save: function () {
        return null;
    }

});


jQuery(function ($) {

    /**
     * Runs every 250 milliseconds to check if a calendar was just loaded
     * and if it was, trigger the window resize to show it
     *
     */
    setInterval(function () {

        $('.wpsbc-overview-container-loaded').each(function () {

            if ($(this).attr('data-just-loaded') == '1') {
                $(window).trigger('resize');
                $(this).attr('data-just-loaded', '0');
            }

        });

    }, 250);

});