import React from 'react';
import Select from 'react-select';

const { ServerSideRender, PanelBody, SelectControl, TextControl }  = wp.components;

const { registerBlockType } = wp.blocks;
const { InspectorControls } = wp.editor;
const { __ } 				= wp.i18n;


/**
 * Block inspector controls options
 *
 */

// The options for the Calendars dropdown
var calendars = [];

for( var i = 0; i < wpsbc_calendars.length; i++ ) {

    var calendar_name = jQuery('<textarea />').html(wpsbc_calendars[i].name).text();

    calendars.push( { value : wpsbc_calendars[i].id, label : calendar_name } );

}

// The option for the Language dropdown
var languages = [];

languages[0] = { value : 'auto', label : __( 'Auto', 'wp-simple-booking-calendar' ) };

for( var i = 0; i < wpsbc_languages.length; i++ ) {

    languages.push( { value : wpsbc_languages[i].code, label : wpsbc_languages[i].name } );

}

// Register the block
registerBlockType( 'wp-simple-booking-calendar/search-widget', {

	// The block's title
    title : 'Calendar Search Widget',

    // The block's icon
    icon : 'search',

    // The block category the block should be added to
    category : 'wp-simple-booking-calendar',

    // The block's attributes, needed to save the data
	attributes : {

		calendars : {
            type : 'string',
            default : null
        },
        language : {
            type    : 'string',
            default : 'auto'
        },

		title : {
            type    : 'string',
            default : 'yes'
        },

        results_per_page : {
            type    : 'string',
            default : '10'
        },

        redirect : {
            type    : 'string',
            default : ''
        }

	},

	edit : function( props ) {

		const selected = ( typeof props.attributes.calendars != 'undefined' ? JSON.parse( props.attributes.calendars ) : {} )
    	const handleSelectChange = ( calendars ) => props.setAttributes( { calendars: JSON.stringify( calendars ) } );

		return [

			<ServerSideRender 
				block 	   = "wp-simple-booking-calendar/search-widget"
				attributes = { props.attributes } />,

			<InspectorControls key="inspector">

				<PanelBody
					title       = { __( 'Calendars', 'wp-simple-booking-calendar' ) }
                    initialOpen = { true } >

                    <Select
                    	label    = { __( 'Calendars', 'wp-simple-booking-calendar' ) }
                        name     = 'select-two'
                        value    = { selected }
                        onChange = { handleSelectChange }
                        options  = { calendars }
						isMulti  = 'true' />

					<p class="description">{ __( 'Select the calendars you wish to be included in the search, or leave empty to show all calendars.', 'wp-simple-booking-calendar' ) }</p>

                    <SelectControl
						label   = { __( 'Language', 'wp-simple-booking-calendar' ) }
                        value   = { props.attributes.language }
                        options = { languages }
                        onChange = { (new_value) => props.setAttributes( { language : new_value } ) } />
					
					<SelectControl
						label   = { __( 'Widget Title', 'wp-simple-booking-calendar' ) }
                        value   = { props.attributes.title }
                        options = {[
                            { value : 'yes', label : __( 'Yes', 'wp-simple-booking-calendar' ) },
                            { value : 'no',  label : __( 'No', 'wp-simple-booking-calendar' ) }
                        ]}
                        onChange = { (new_value) => props.setAttributes( { title : new_value } ) } />
                    
                    <TextControl
						label   = { __( 'Results per Page', 'wp-simple-booking-calendar' ) }
                        value   = { props.attributes.results_per_page }
                        onChange = { (new_value) => props.setAttributes( { results_per_page : new_value } ) } />

                    <TextControl
						label   = { __( 'Redirect', 'wp-simple-booking-calendar' ) }
                        value   = { props.attributes.redirect }
                        onChange = { (new_value) => props.setAttributes( { redirect : new_value } ) } />

				</PanelBody>

			</InspectorControls>
		];
	},

	save : function() {
		return null;
	}

});


jQuery(function ($) {

	/**
	 * Runs every 250 milliseconds to check if a calendar was just loaded
	 * and if it was, trigger the window resize to show it
	 *
	 */
	setInterval(function () {

        jQuery('.wpsbc-search-container-loaded').each(function () {
            if (jQuery(this).attr('data-just-loaded') == '1') {
                jQuery(window).trigger('resize');
                jQuery(this).attr('data-just-loaded', '0');
            }
        });
		
	}, 250);
});