<?php
class WPSBC_Divi_Module_SingleCalendar extends ET_Builder_Module
{

    public $slug = 'wpsbc_divi_single_calendar';
    public $vb_support = 'on';

    public function init()
    {
        $this->name = esc_html__('Single Calendar', 'wp-simple-booking-calendar');
    }

    public function get_fields()
    {

        // Calendars
        $calendars_dropdown = array();
        $calendars_dropdown['0-no-calendar'] = '-';
        $calendars = wpsbc_get_calendars(array('status' => 'active'));
        foreach ($calendars as $calendar) {
            $calendars_dropdown[$calendar->get('id')] = $calendar->get('name');
        }


        // Months to Display
        $months_to_display = array();
        for ($i = 1; $i <= 24; $i++) {
            $months_to_display[$i] = (string) $i;
        }

        // Start Year
        $start_year = array();
        $start_year['0-wpsbc-default'] = __('Current Year', 'wp-simple-booking-calendar');
        for ($i = date('Y'); $i <= date('Y') + 10; $i++) {
            $start_year[$i] = (string) $i;
        }

        // Start Month
        $start_month = array(
            '0-wpsbc-default' => __('Current Month', 'wp-simple-booking-calendar'),
            '1' => __('January', 'wp-simple-booking-calendar'),
            '2' => __('February', 'wp-simple-booking-calendar'),
            '3' => __('March', 'wp-simple-booking-calendar'),
            '4' => __('April', 'wp-simple-booking-calendar'),
            '5' => __('May', 'wp-simple-booking-calendar'),
            '6' => __('June', 'wp-simple-booking-calendar'),
            '7' => __('July', 'wp-simple-booking-calendar'),
            '8' => __('August', 'wp-simple-booking-calendar'),
            '9' => __('September', 'wp-simple-booking-calendar'),
            '10' => __('October', 'wp-simple-booking-calendar'),
            '11' => __('November', 'wp-simple-booking-calendar'),
            '12' => __('December', 'wp-simple-booking-calendar'),
        );

        // Languages
        $languages_dropdown = array();
        $settings = get_option('wpsbc_settings', array());
        $languages = wpsbc_get_languages();
        $active_languages = (!empty($settings['active_languages']) ? $settings['active_languages'] : array());

        $languages_dropdown['auto'] = __('Auto (let WP choose)', 'wp-simple-booking-calendar');

        foreach ($active_languages as $code) {
            $languages_dropdown[esc_attr($code)] = (!empty($languages[$code]) ? $languages[$code] : '');
        }

        // Week Days
        $week_days = array(
            1 => __('Monday', 'wp-simple-booking-calendar'),
            2 => __('Tuesday', 'wp-simple-booking-calendar'),
            3 => __('Wednesday', 'wp-simple-booking-calendar'),
            4 => __('Thursday', 'wp-simple-booking-calendar'),
            5 => __('Friday', 'wp-simple-booking-calendar'),
            6 => __('Saturday', 'wp-simple-booking-calendar'),
            7 => __('Sunday', 'wp-simple-booking-calendar'),
        );


        return array(
            'id' => array(
                'label' => esc_html__('Calendar', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'option_category' => 'basic_option',
                'options' => $calendars_dropdown,
                'default' => '0-no-calendar',
            ),

            'title' => array(
                'label' => esc_html__('Display Calendar Title', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => 'yes',
                'option_category' => 'basic_option',
                'options' => array('yes' => __('Yes', 'wp-simple-booking-calendar'), 'no' => __('No', 'wp-simple-booking-calendar')),
            ),

            'legend' => array(
                'label' => esc_html__('Display Legend', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => 'yes',
                'option_category' => 'basic_option',
                'options' => array('yes' => __('Yes', 'wp-simple-booking-calendar'), 'no' => __('No', 'wp-simple-booking-calendar')),
            ),

            'legend_position' => array(
                'label' => esc_html__('Legend Position', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => 'side',
                'option_category' => 'basic_option',
                'options' => array('side' => __('Side', 'wp-simple-booking-calendar'), 'top' => __('Top', 'wp-simple-booking-calendar'), 'bottom' => __('Bottom', 'wp-simple-booking-calendar')),
            ),

            'display' => array(
                'label' => esc_html__('Months to Display', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => '1',
                'option_category' => 'basic_option',
                'options' => $months_to_display,
            ),

            'year' => array(
                'label' => esc_html__('Start Year', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => '0-wpsbc-default',
                'option_category' => 'basic_option',
                'options' => $start_year,
            ),

            'month' => array(
                'label' => esc_html__('Start Month', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => '0-wpsbc-default',
                'option_category' => 'basic_option',
                'options' => $start_month,
            ),

            'language' => array(
                'label' => esc_html__('Language', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => 'auto',
                'option_category' => 'basic_option',
                'options' => $languages_dropdown,
            ),

            'start' => array(
                'label' => esc_html__('Week Start Day', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => '1',
                'option_category' => 'basic_option',
                'options' => $week_days,
            ),

            'dropdown' => array(
                'label' => esc_html__('Display Selection Dropdown', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => 'yes',
                'option_category' => 'basic_option',
                'options' => array('yes' => __('Yes', 'wp-simple-booking-calendar'), 'no' => __('No', 'wp-simple-booking-calendar')),
                'description' => __("If set to yes, the calendar will display a month and year drop-down select field as a navigation alternative to the arrows.", 'wp-simple-booking-calendar'),
            ),

            'jump' => array(
                'label' => esc_html__('Use Jump Switch', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'option_category' => 'basic_option',
                'default' => 'no',
                'options' => array('yes' => __('Yes', 'wp-simple-booking-calendar'), 'no' => __('No', 'wp-simple-booking-calendar')),
                'description' => __("If set to yes and if the calendar displays multiple months, when the user uses the arrows to navigate the calendar, the calendar will switch the number of months selected, rather than just one month.", 'wp-simple-booking-calendar'),
            ),

            'history' => array(
                'label' => esc_html__('Show History', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => '1',
                'option_category' => 'basic_option',
                'options' => array(
                    '1' => __('Display booking history', 'wp-simple-booking-calendar'),
                    '2' => __('Replace booking history with the default legend item', 'wp-simple-booking-calendar'),
                    '3' => __('Use the Booking History Color from the Settings', 'wp-simple-booking-calendar'),
                ),
                'description' => __("This option lets you decide how past dates are being displayed for the user in the front-end.", 'wp-simple-booking-calendar'),
            ),

            'tooltip' => array(
                'label' => esc_html__('Display Tooltips', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => '1',
                'option_category' => 'basic_option',
                'options' => array(
                    '1' => __('No', 'wp-simple-booking-calendar'),
                    '2' => __('Yes', 'wp-simple-booking-calendar'),
                    '3' => __('Yes, with red indicator', 'wp-simple-booking-calendar'),
                ),
            ),

            'highlighttoday' => array(
                'label' => esc_html__('Highlight Today', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'option_category' => 'basic_option',
                'default' => 'no',
                'options' => array('yes' => __('Yes', 'wp-simple-booking-calendar'), 'no' => __('No', 'wp-simple-booking-calendar')),
            ),

            'weeknumbers' => array(
                'label' => esc_html__('Show Week Numbers', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'option_category' => 'basic_option',
                'default' => 'no',
                'options' => array('yes' => __('Yes', 'wp-simple-booking-calendar'), 'no' => __('No', 'wp-simple-booking-calendar')),
                'description' => __("If set to yes, it will display at the beginning of each week the week's number counted from the beginning of the year.", 'wp-simple-booking-calendar'),
            )

        );
    }

    public function render($attrs, $content = null, $render_slug = null)
    {
        if (empty($this->props['id'])) {
            return '<div style="padding: 20px; background-color: #f1f1f1;">' . __('Please select a calendar to display.') . '</div>';
        }

        $props = array();

        foreach($this->props as $key => $prop){
            $props[$key] = str_replace('0-wpsbc-default', '0', $prop);
        }

        // Execute the shortcode
        return WPSBC_Shortcodes::single_calendar($props);
    }
}

new WPSBC_Divi_Module_SingleCalendar;
